/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.execute;

import ch.e2e.builder.compiler.build.types.DebugException;
import ch.e2e.builder.compiler.execute.Logging;
import ch.e2e.builder.compiler.net.LoginFailedException;
import ch.e2e.builder.compiler.net.UnknownHttpException;
import ch.e2e.builder.trace.testcase.TestcaseWatch;
import ch.e2e.builder.trace.testcase.uml.TypeMapper;
import ch.e2e.dom.BridgeNamespaceContext;
import ch.e2e.dom.DomUtilities;
import ch.e2e.swing.TreeObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DebuggerResponse {
    private static final Matcher MATCHER = Pattern.compile("file=([^&]*)").matcher("");
    private String fileName;
    private final Document document;
    private String sessionId;
    private String documentId;
    private DebugException exception;
    private List<CallStackEntry> callStack;
    private Activity activity;

    public DebuggerResponse(URL url, String username, String password) throws IOException, SAXException, ParserConfigurationException, LoginFailedException {
        this(DebuggerResponse.document(url, username, password));
        MATCHER.reset(url.toString());
        this.fileName = MATCHER.find() ? MATCHER.group(1) : "Unknown";
    }

    public DebuggerResponse(File file) throws IOException, SAXException, ParserConfigurationException {
        this(DomUtilities.parse((File)file, (boolean)false, (boolean)false));
        this.fileName = file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Document document(URL url, String username, String password) throws IOException, ParserConfigurationException, SAXException, LoginFailedException {
        Document document;
        String file = "/admin/Console/Welcome?j_username=" + username + "&j_password=" + password;
        URL loginUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(loginUrl.toString());
        int result = client.executeMethod((HttpMethod)method);
        method.releaseConnection();
        if (result == 302 || result == 301 || result == 303 || result == 307) {
            method = new GetMethod(url.toString());
            result = client.executeMethod((HttpMethod)method);
            if (result != 200) throw new UnknownHttpException(method.getResponseBodyAsString(), result);
            try (InputStream response = method.getResponseBodyAsStream();){
                document = DomUtilities.parse((InputStream)response, (boolean)false, (boolean)false);
            }
        } else {
            String login = loginUrl.toString();
            int idx = login.indexOf(63);
            if (idx == -1) throw new LoginFailedException("Login failed on '" + login + "'.");
            login = login.substring(0, idx);
            throw new LoginFailedException("Login failed on '" + login + "'.");
        }
        method.releaseConnection();
        return document;
    }

    public DebuggerResponse(Document document) {
        this.document = document;
        if (document == null) {
            return;
        }
        NodeList nodes = document.getElementsByTagName("Session");
        if (nodes.getLength() > 0) {
            this.setSessionId((Element)nodes.item(0));
        }
        if ((nodes = document.getElementsByTagName("CallStack")).getLength() == 0) {
            this.callStack = Collections.emptyList();
        } else {
            this.setCallStack((Element)nodes.item(0));
        }
        nodes = document.getElementsByTagName("Exception");
        Element exceptionElement = null;
        if (nodes.getLength() > 0) {
            exceptionElement = (Element)nodes.item(0);
            this.setException(exceptionElement);
        }
        if ((nodes = document.getElementsByTagName("Activity")).getLength() > 0) {
            this.setActivity((Element)nodes.item(0), exceptionElement, new BridgeNamespaceContext(new Node[]{document.getDocumentElement()}));
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public Document getResponseDocument() {
        return this.document;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    private void setSessionId(Element element) {
        this.sessionId = element.getElementsByTagName("SessionID").item(0).getTextContent();
    }

    public DebugException getException() {
        return this.exception;
    }

    private void setException(Element element) {
        this.exception = new DebugException(element, this.documentId);
    }

    public Activity getActivity() {
        return this.activity;
    }

    private void setActivity(Element activtiyElement, Element exceptionElement, BridgeNamespaceContext namespaceContext) {
        this.activity = new Activity(activtiyElement, exceptionElement, this.sessionId, namespaceContext);
    }

    public List<CallStackEntry> getCallStack() {
        return this.callStack;
    }

    private void setCallStack(Element element) {
        NodeList nodes = element.getElementsByTagName("Call");
        int nNodes = nodes.getLength();
        boolean callStackEmpty = nNodes == 0;
        this.callStack = callStackEmpty ? Collections.emptyList() : new ArrayList(nNodes);
        for (int i = nNodes - 1; i > -1; --i) {
            Element item = (Element)nodes.item(i);
            if ("preprocessor".equals(item.getAttribute("id"))) continue;
            this.callStack.add(new CallStackEntry(item, this.sessionId));
        }
        this.documentId = callStackEmpty ? null : this.callStack.get(0).getDocumentId();
    }

    private static class UmlElementId {
        private static final Matcher MATCHER = Pattern.compile("(?:\\$.*?\\$)(\\w*?)(?:\\$.*)").matcher("");
        private static final String SEP_1 = "...";
        private static final String SEP_2 = "|";
        private static final int LENGTH_1 = "...".length();
        private static final int LENGTH_2 = "|".length();
        private String name;
        private String documentId;
        private String xmiId;

        public UmlElementId(String id) throws IllegalArgumentException {
            int index_2 = id.lastIndexOf(SEP_2);
            if (index_2 == -1) {
                throw new IllegalArgumentException(id);
            }
            int index_1 = id.substring(0, index_2).lastIndexOf(SEP_1);
            if (index_1 > 0) {
                this.name = id.substring(0, index_1);
            }
            try {
                this.documentId = id.substring(index_1 > -1 ? index_1 + LENGTH_1 : 0, index_2);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            this.xmiId = id.substring(index_2 + LENGTH_2);
            if (MATCHER.reset(this.xmiId).matches()) {
                this.xmiId = MATCHER.group(1);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public String getXmiId() {
            return this.xmiId;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof UmlElementId && this.toString().equals(obj.toString());
        }

        public String toString() {
            return (this.name == null ? "" : this.name + SEP_1) + this.documentId + (this.xmiId == null ? "" : SEP_2 + this.xmiId);
        }
    }

    public static class CallStackEntry {
        private static final String ATTRIBUTE_NAME = "name";
        private static final String ATTRIBUTE_STATEMENT_INDEX = "statementIndex";
        private String sessionId;
        private String documentId;
        private String xmiId;
        private String fullName;
        private String path;
        private String name;
        private Integer statementIndex;

        public CallStackEntry(Element entry, String sessionId) {
            this.sessionId = sessionId;
            try {
                UmlElementId id = new UmlElementId(entry.getAttribute("id"));
                this.documentId = id.getDocumentId();
                this.xmiId = id.getXmiId();
            }
            catch (IllegalArgumentException id) {
                // empty catch block
            }
            this.fullName = entry.getAttribute(ATTRIBUTE_NAME);
            int index = this.fullName.lastIndexOf("...");
            if (index > -1) {
                this.fullName = this.fullName.substring(0, index);
            }
            if ((index = this.fullName.lastIndexOf(46)) > -1) {
                this.path = this.fullName.substring(0, index);
                this.name = this.fullName.substring(index + 1);
            } else {
                this.path = null;
                this.name = this.fullName;
            }
            String attr = entry.getAttribute(ATTRIBUTE_STATEMENT_INDEX);
            if (attr.length() > 0) {
                this.statementIndex = Integer.valueOf(attr);
            }
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public String getXmiId() {
            return this.xmiId;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public Integer getStatementIndex() {
            return this.statementIndex;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String toString() {
            return this.getFullName();
        }

        public boolean equals(Object obj) {
            return obj instanceof CallStackEntry && this.xmiId.equals(((CallStackEntry)obj).getXmiId());
        }

        public int hashCode() {
            return this.xmiId.hashCode();
        }
    }

    public static class Activity
    implements TreeObject {
        private final String sessionId;
        private String path;
        private String name;
        private String nodeName;
        private String statement = "";
        private boolean exceptionThrown;
        private List<TestcaseWatch> watches;

        public Activity(Element activtiyElement, Element exceptionElement, String sessionId, BridgeNamespaceContext namespaceContext) {
            this.sessionId = sessionId;
            this.setNameAndPath(activtiyElement);
            this.setNodeName(activtiyElement);
            this.setWatches(activtiyElement, exceptionElement, namespaceContext);
        }

        private void setWatches(Element activtiyElement, Element exceptionElement, BridgeNamespaceContext namespaceContext) {
            Element adapterIO = (Element)activtiyElement.getElementsByTagName("adapterIO").item(0);
            Element context = (Element)activtiyElement.getElementsByTagName("Context").item(0);
            NodeList contextChildNodes = null;
            if (context == null) {
                Logging.logger.severe("Context element missing in response of '" + this.toString() + "'");
                contextChildNodes = new NodeList(){

                    @Override
                    public Node item(int index) {
                        return null;
                    }

                    @Override
                    public int getLength() {
                        return 0;
                    }
                };
            } else {
                try {
                    contextChildNodes = (NodeList)DomUtilities.evaluate((Node)context, (String)"*", (QName)XPathConstants.NODESET);
                }
                catch (XPathExpressionException xPathExpressionException) {
                    // empty catch block
                }
            }
            int nContextChildNodes = contextChildNodes.getLength();
            this.watches = exceptionElement == null && adapterIO == null && nContextChildNodes == 0 ? Collections.emptyList() : new ArrayList<TestcaseWatch>();
            boolean bl = this.exceptionThrown = exceptionElement != null;
            if (this.exceptionThrown) {
                this.watches.add(new TestcaseWatch(null, -1, exceptionElement));
            }
            if (adapterIO != null) {
                TypeMapper.mapTypes((Element)adapterIO, (BridgeNamespaceContext)namespaceContext);
                this.watches.add(new TestcaseWatch(null, -1, adapterIO));
            }
            for (int i = 0; i < nContextChildNodes; ++i) {
                Node child = contextChildNodes.item(i);
                TypeMapper.mapTypes((Element)((Element)child), (BridgeNamespaceContext)namespaceContext);
                this.watches.add(new TestcaseWatch(null, -1, (Element)child));
            }
        }

        private void setNodeName(Element activtiyElement) {
            this.nodeName = activtiyElement.getAttribute("node");
            int idx = this.nodeName.indexOf("...");
            if (idx != -1) {
                this.nodeName = this.nodeName.substring(0, idx);
            }
            try {
                this.statement = " (statement " + Integer.parseInt(activtiyElement.getAttribute("statementIndex")) + ")";
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.nodeName.length() == 0) {
                this.nodeName = null;
            }
        }

        private void setNameAndPath(Element activtiyElement) {
            this.name = activtiyElement.getAttribute("name");
            int idx = this.name.indexOf("...");
            if (idx > -1) {
                this.name = this.name.substring(0, idx);
            }
            if ((idx = this.name.lastIndexOf(46)) > -1) {
                this.path = this.name.substring(0, idx);
                this.name = this.name.substring(idx + 1);
            } else {
                this.path = "";
            }
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getName() {
            return this.name;
        }

        public String getNodeName() {
            return this.nodeName == null ? null : this.nodeName + this.statement;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isExceptionThrown() {
            return this.exceptionThrown;
        }

        public TestcaseWatch getWatch(int index) {
            return this.watches.get(index);
        }

        public Object getChild(int index) {
            return this.getWatch(index);
        }

        public int getChildCount() {
            return this.watches.size();
        }

        public int getIndexOfChild(Object child) {
            this.watches.indexOf(child);
            int index = -1;
            if (child != null) {
                for (int i = 0; index == -1 && i < this.getChildCount(); ++i) {
                    if (child != this.getChild(i)) continue;
                    index = i;
                }
            }
            return index;
        }

        public boolean isLeaf() {
            return this.watches.isEmpty();
        }

        public int getType() {
            return -1;
        }

        public String toString() {
            return this.path + "." + this.name + (this.nodeName == null ? "" : " :" + this.nodeName + this.statement);
        }

        public boolean equals(Object obj) {
            boolean equal = false;
            if (obj instanceof Activity) {
                Activity activity = (Activity)obj;
                equal = this.sessionId.equals(activity.sessionId) && this.path.equals(activity.path) && this.name.equals(activity.name);
            }
            return equal;
        }

        public int hashCode() {
            return (this.sessionId + this.path + this.name).hashCode();
        }
    }
}

