/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.java;

import ch.e2e.bridge.server.BridgeJavaCallback;
import ch.e2e.bridge.server.BridgeJavaService;
import ch.e2e.builder.compiler.document.importer.java.Completable;
import ch.e2e.builder.compiler.document.importer.java.ImportClassLoader;
import ch.e2e.builder.compiler.document.importer.java.JavaClass;
import ch.e2e.builder.compiler.uml.BridgeClass;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class TypeInfo {
    private static final Map<String, TypeInfo> instances = new HashMap<String, TypeInfo>();
    private ImportClassLoader classLoader;
    private Class<?> javaType;
    private String nativeType = null;
    private String nativeArrayElement = null;
    private BridgeClass type = null;
    private BridgeClass arrayElement = null;
    boolean array = false;
    private int arrayDimension = 0;
    boolean collection = false;
    boolean map = false;

    private TypeInfo(Class<?> javaType, ImportClassLoader classLoader) {
        this.javaType = javaType;
        this.classLoader = classLoader;
    }

    public static TypeInfo getTypeInfo(Class<?> javaType, ImportClassLoader classLoader) {
        return TypeInfo.getTypeInfo(javaType.getName(), javaType, classLoader);
    }

    public static TypeInfo getTypeInfo(JavaClass type, ImportClassLoader classLoader) {
        return TypeInfo.getTypeInfo(type.getFullName(), type.getJavaType(), classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeInfo getTypeInfo(String classname, Class<?> javaType, ImportClassLoader classLoader) {
        TypeInfo typeInfo = instances.get(classname);
        if (typeInfo == null) {
            Map<String, TypeInfo> map = instances;
            synchronized (map) {
                typeInfo = instances.get(classname);
                if (typeInfo == null) {
                    typeInfo = new TypeInfo(javaType, classLoader);
                    instances.put(classname, typeInfo);
                    if (!typeInfo.findTypes(javaType)) {
                        instances.remove(classname);
                        typeInfo = null;
                    }
                }
            }
        }
        return typeInfo;
    }

    public static void reset() {
        instances.clear();
    }

    public boolean isBaseType() {
        return !(this.type instanceof JavaClass);
    }

    public static boolean isBaseType(Completable element) {
        return !(element.getTypeClass() instanceof JavaClass);
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public BridgeClass getBridgeType() {
        return this.type;
    }

    public BridgeClass getArrayElement() {
        return this.arrayElement;
    }

    public String getNativeType() {
        return this.nativeType;
    }

    public String getNativeArrayElement() {
        return this.nativeArrayElement;
    }

    public int getArrayDimension() {
        return this.arrayDimension;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public boolean isMap() {
        return this.map;
    }

    private boolean findTypes(Class<?> clazz) {
        boolean result = true;
        String classname = clazz.getName();
        this.array = clazz.isArray();
        this.collection = Collection.class.isAssignableFrom(clazz);
        this.map = Map.class.isAssignableFrom(clazz);
        if (InputStream.class.isAssignableFrom(clazz) || byte[].class.isAssignableFrom(clazz) || Byte[].class.isAssignableFrom(clazz)) {
            this.type = this.getBaseType("Base Types/Blob");
            if (byte[].class.isAssignableFrom(clazz)) {
                this.nativeType = "byte[]";
                this.nativeArrayElement = "byte";
            } else if (Byte[].class.isAssignableFrom(clazz)) {
                this.nativeType = "java.lang.Byte[]";
                this.nativeArrayElement = "java.lang.Byte";
            } else {
                this.nativeType = classname;
            }
            this.array = false;
        } else if (this.array) {
            TypeInfo componentTypeInfo = TypeInfo.getTypeInfo(clazz.getComponentType(), this.classLoader);
            this.type = this.getBaseType("Base Types/Array");
            this.nativeType = null;
            this.arrayElement = componentTypeInfo.getBridgeType();
            if (this.arrayElement.getModule() != null) {
                this.nativeArrayElement = componentTypeInfo.getNativeType();
            }
            this.array = true;
            ++this.arrayDimension;
        } else if (this.collection || this.map) {
            this.type = this.getBaseType("Base Types/Array");
            this.nativeType = classname;
        } else if (classname.equals(Byte.class.getName()) || classname.equals(Byte.TYPE.getName()) || classname.equals(Short.class.getName()) || classname.equals(Short.TYPE.getName()) || classname.equals(Integer.class.getName()) || classname.equals(Integer.TYPE.getName()) || classname.equals(Long.class.getName()) || classname.equals(Long.TYPE.getName()) || classname.equals(BigInteger.class.getName())) {
            this.type = this.getBaseType("Base Types/Integer");
            this.nativeType = classname;
        } else if (classname.equals(Double.class.getName()) || classname.equals(Double.TYPE.getName()) || classname.equals(Float.class.getName()) || classname.equals(Float.TYPE.getName()) || classname.equals(BigDecimal.class.getName())) {
            this.type = this.getBaseType("Base Types/Float");
            this.nativeType = classname;
        } else if (classname.equals(String.class.getName()) || classname.equals(StringBuffer.class.getName()) || classname.equals(Character.class.getName()) || classname.equals(Character.TYPE.getName())) {
            this.type = this.getBaseType("Base Types/String");
            this.nativeType = classname;
        } else if (classname.equals(Boolean.class.getName()) || classname.equals(Boolean.TYPE.getName())) {
            this.type = this.getBaseType("Base Types/Boolean");
            this.nativeType = classname;
        } else if (classname.equals(Object.class.getName())) {
            this.type = this.getBaseType("Base Types/Any");
            this.nativeType = classname;
        } else if (Date.class.isAssignableFrom(clazz) || GregorianCalendar.class.isAssignableFrom(clazz)) {
            this.type = this.getBaseType("Base Types/DateTime");
            this.nativeType = classname;
        } else {
            try {
                if (this.classLoader != null) {
                    this.type = this.classLoader.loadJavaClass(classname, false);
                    this.classLoader.initializeJavaClass((JavaClass)this.type, classname, false, false);
                    if (this.type == null) {
                        result = false;
                    } else {
                        this.nativeType = classname;
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    private BridgeClass getBaseType(String typeName) {
        return this.classLoader.getHelpers().getElementHelper().findBaseType(typeName, null);
    }

    public static TypeInfo getDefaultTypeInfo() {
        return TypeInfo.getTypeInfo(Object.class, null);
    }

    public static boolean isJavaCallback(Class<?> clazz) {
        return clazz.isInterface() && TypeInfo.isImplementationOf(clazz, BridgeJavaCallback.class);
    }

    public static boolean isJavaService(Class<?> clazz) {
        return TypeInfo.isImplementationOf(clazz, BridgeJavaService.class);
    }

    private static boolean isImplementationOf(Class<?> clazz, Class<?> compareClass) {
        boolean result = false;
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length && !result; ++i) {
            result = interfaces[i].getName().equals(compareClass.getName());
        }
        return result;
    }
}

