/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.idoc;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.document.importer.ImportException;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.document.importer.idoc.IDoc;
import ch.e2e.builder.compiler.document.importer.idoc.IDocBuilder;
import ch.e2e.builder.compiler.document.importer.idoc.IDocContainerObject;
import ch.e2e.builder.compiler.document.importer.idoc.IDocImportException;
import ch.e2e.builder.compiler.document.importer.idoc.Logging;
import ch.e2e.builder.compiler.document.importer.idoc.SchemaBuilder;
import ch.e2e.builder.compiler.document.importer.wsdl.WsdlImportTransaction;
import ch.e2e.builder.compiler.error.ImportError;
import ch.e2e.builder.compiler.uml.Helpers;
import java.io.File;
import org.w3c.dom.Document;

public class IDocImportTransaction
extends WsdlImportTransaction {
    public static final String IDOC_WSDL_DOCUMENT = "idoc.wsdl.document";
    public static final String GRAMMAR_FILE = "grammar.file";
    public static final String DOCUMENTATION_FILE = "documentation.file";
    public static final String PACKAGE_NAME = "package.name";
    public static final String VERSION = "version";

    public IDocImportTransaction(File importsFolder, String description, Helpers helpers) {
        super(importsFolder, description, helpers);
    }

    @Override
    public void doTransaction(ImporterData importerData) {
        XSLTErrorHandler.getInstance().reset();
        File grammarFile = (File)importerData.getSource(GRAMMAR_FILE);
        File documentationFile = (File)importerData.getSource(DOCUMENTATION_FILE);
        String packageName = (String)importerData.getSource(PACKAGE_NAME);
        int version = (Integer)importerData.getSource(VERSION);
        IDocContainerObject.setVersion(version);
        Document wsdlDocument = this.callConverter(grammarFile, documentationFile, packageName, version);
        if (wsdlDocument != null) {
            importerData.addSource(IDOC_WSDL_DOCUMENT, wsdlDocument);
            super.doTransaction(importerData);
        }
    }

    @Override
    protected String getSourceKey() {
        return IDOC_WSDL_DOCUMENT;
    }

    @Override
    protected String getSourceType(Document wsdl2idl) {
        return "idoc";
    }

    private Document callConverter(File grammarFile, File docFile, String packageName, int version) {
        Document wsdlDocument = null;
        IDoc idoc = this.buildIDoc(grammarFile, docFile, packageName);
        if (idoc != null) {
            try {
                wsdlDocument = SchemaBuilder.buildSchema(idoc, version);
                this.printSourceDocument(wsdlDocument, grammarFile.getName());
            }
            catch (Exception e) {
                XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportException(e));
                Logging.logger.throwing(this.getClass().getName(), "callConverter", e);
            }
        }
        return wsdlDocument;
    }

    private IDoc buildIDoc(File idocFile, File htmlFile, String packageName) {
        IDoc idoc;
        block2: {
            idoc = null;
            IDocBuilder builder = new IDocBuilder();
            try {
                idoc = builder.build(idocFile, htmlFile, packageName);
            }
            catch (IDocImportException e) {
                XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportError(e.getMessage()));
                Logging.logger.severe(e.getMessage());
                if (e.getCause() == null) break block2;
                Logging.logger.throwing(this.getClass().getName(), "buildIDoc", e.getCause());
            }
        }
        return idoc;
    }
}

