/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.idoc;

import ch.e2e.builder.compiler.document.importer.idoc.DocumentationParser;
import ch.e2e.builder.compiler.document.importer.idoc.IDoc;
import ch.e2e.builder.compiler.document.importer.idoc.IDocImportException;
import ch.e2e.builder.compiler.document.importer.idoc.StringConstants;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.BOMReader;
import ch.e2e.io.Logging;
import ch.e2e.util.StringTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class IDocBuilder
implements Logging,
StringConstants {
    public IDoc build(File grammarFile, File docuFile, String packageName) throws IDocImportException {
        try {
            String grammarXML = IDocBuilder.grammarToXML(grammarFile);
            Document fragment = DomUtilities.parse((Reader)new StringReader(grammarXML), (boolean)false, (boolean)false);
            IDoc idoc = new IDoc((Element)fragment.getDocumentElement().getFirstChild());
            idoc.setPackageName(packageName);
            if (docuFile != null) {
                DocumentationParser documentationParser = new DocumentationParser(docuFile);
                documentationParser.parse();
                idoc.applyFieldMeta(documentationParser);
            }
            return idoc;
        }
        catch (IOException e) {
            throw new IDocImportException("idoc.import.error.grammar.io.error", e);
        }
        catch (ParserConfigurationException e) {
            throw new IDocImportException("idoc.import.error.grammar.parse.error", e);
        }
        catch (SAXException e) {
            throw new IDocImportException("idoc.import.error.grammar.parse.error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String grammarToXML(File grammarFile) throws IOException {
        BufferedReader reader = null;
        StringBuilder xml = new StringBuilder();
        try {
            reader = new BufferedReader((Reader)new BOMReader((InputStream)new FileInputStream(grammarFile)));
            String line = reader.readLine();
            while (line != null) {
                String s = IDocBuilder.convertLine(line.trim(), reader);
                if (s != null && s.length() != 0) {
                    xml.append(s);
                }
                line = reader.readLine();
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        return xml.toString();
    }

    private static String convertLine(String line, BufferedReader reader) throws IOException {
        StringBuffer retval;
        if (line.length() == 0) {
            retval = new StringBuffer("");
        } else {
            String[] parts = line.split("[\\s]+");
            retval = new StringBuffer();
            String uc = parts[0].toUpperCase();
            if (uc.startsWith("BEGIN")) {
                retval.append("<").append(parts[0].substring(6));
                if (parts.length == 2) {
                    retval.append(" name='").append(parts[1]).append("'");
                }
                retval.append(">");
            } else if (uc.startsWith("END")) {
                retval.append("</").append(parts[0].substring(4)).append(">");
            } else {
                retval.append("<").append(parts[0]).append(">");
                for (int i = 1; i < parts.length; ++i) {
                    parts[i] = StringTools.replaceChars((String)parts[i], (String)"<>&", (String[])new String[]{"&gt;", "&gt;", "&amp;"});
                    retval.append(parts[i]);
                    retval.append(" ");
                }
                if (parts.length > 1) {
                    retval.setLength(retval.length() - 1);
                }
                retval.append("</").append(parts[0]).append(">");
            }
            if (uc.startsWith("BEGIN_FIELDS")) {
                retval.append("<FIELD>");
                line = reader.readLine();
                while (line != null) {
                    parts = line.trim().split("[\\s]+");
                    uc = parts[0].toUpperCase();
                    if (uc.startsWith("END_FIELDS")) {
                        retval.append("</FIELD></FIELDS>");
                        break;
                    }
                    String s = IDocBuilder.convertFieldsLine(line.trim());
                    if (s.length() != 0) {
                        retval.append(s);
                    }
                    line = reader.readLine();
                }
            }
        }
        return retval.toString();
    }

    private static String convertFieldsLine(String line) {
        StringBuffer retval;
        if (line.length() == 0) {
            retval = new StringBuffer("</FIELD><FIELD>");
        } else {
            String[] parts = line.split("[\\s]+");
            retval = new StringBuffer();
            String uc = parts[0].toUpperCase();
            retval.append("<").append(parts[0]).append(">");
            for (int i = 1; i < parts.length; ++i) {
                parts[i] = StringTools.replaceChars((String)parts[i], (String)"<>&", (String[])new String[]{"&gt;", "&gt;", "&amp;"});
                retval.append(parts[i]);
                retval.append(" ");
            }
            if (parts.length > 1) {
                retval.setLength(retval.length() - 1);
            }
            retval.append("</").append(parts[0]).append(">");
        }
        return retval.toString();
    }
}

