/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.idoc;

import ch.e2e.io.Logging;
import java.util.ArrayList;

public class FieldMeta
implements Logging {
    private String[] intTypeNames = new String[]{"internal data type", "interner Datentyp"};
    private String[] intLengthNames = new String[]{"internal length", "interne L\u00e4nge"};
    private String[] posInSegNames = new String[]{"position in segment", "Position in Segment"};
    private String[] offsetNames = new String[]{"offset", "Offset"};
    private String[] extLengthNames = new String[]{"external length", "externe L\u00e4nge"};
    private String[] noDecPlaces = new String[]{"No decimal places", "keine Dezimalstellen"};
    private String[] hasNoSignWords = new String[]{"without", "ohne"};
    public String segmentName = "";
    public String name = "";
    private String documentation;
    private String internalDataType = "";
    private int internalLength = -1;
    private int externalLength = -1;
    private String decimals;
    private String sign;
    private int offset = -1;
    public int positionInSegment = -1;

    public FieldMeta(String s) {
        String[] lines = this.buildLines(s);
        this.importData(lines);
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getDecimals() {
        return this.decimals;
    }

    public String getSign() {
        return this.sign;
    }

    public String getInternalDataType() {
        return this.internalDataType;
    }

    public int getInternalLength() {
        return this.internalLength;
    }

    public int getExternalLength() {
        return this.externalLength;
    }

    private String[] buildLines(String s) {
        s = s.replaceAll("<p>", "<br>");
        String[] lines = s.split("<br>");
        ArrayList<String> v = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() == 0) continue;
            if (lines[i].startsWith("Position")) {
                String[] sa = this.binarySplit(lines[i], ",");
                v.add(sa[0]);
                sa = this.binarySplit(sa[1], ".");
                v.add(sa[0]);
                v.add(sa[1]);
                continue;
            }
            v.add(lines[i]);
        }
        ArrayList<String> v2 = new ArrayList<String>();
        for (String ns : v) {
            v2.add(this.removeSurroundingWhitespace(ns));
        }
        String[] sa = new String[v2.size()];
        return v2.toArray(sa);
    }

    private void importData(String[] lines) {
        String s = "";
        try {
            for (int i = 0; i < lines.length; ++i) {
                String signPart;
                String b;
                String value;
                String fieldName;
                s = lines[i];
                if (s.indexOf(":") > -1) {
                    String[] sa = this.binarySplit(s, ":");
                    fieldName = sa[0];
                    value = sa[1];
                } else {
                    fieldName = s;
                    value = "";
                }
                fieldName = this.removeSurroundingWhitespace(fieldName);
                if (this.isOneOf(fieldName, this.intTypeNames)) {
                    this.internalDataType = this.removeSurroundingWhitespace(value);
                    continue;
                }
                if (this.isOneOf(fieldName, this.intLengthNames)) {
                    value = this.removeSurroundingWhitespace(value);
                    b = value.split(" ")[0];
                    try {
                        this.internalLength = Integer.parseInt(b);
                    }
                    catch (Exception e) {
                        logger.warning("Could not parse number from " + b);
                    }
                    continue;
                }
                if (this.isOneOf(fieldName, this.posInSegNames)) {
                    b = this.removeSurroundingWhitespace(value);
                    try {
                        this.positionInSegment = Integer.parseInt(b);
                    }
                    catch (Exception e) {
                        logger.warning("Could not parse number from " + b);
                    }
                    continue;
                }
                if (this.isOneOf(fieldName, this.offsetNames)) {
                    b = this.removeSurroundingWhitespace(value);
                    try {
                        this.offset = Integer.parseInt(b);
                    }
                    catch (Exception e) {
                        logger.warning("Could not parse number from " + b);
                    }
                    continue;
                }
                if (this.isOneOf(fieldName, this.extLengthNames)) {
                    value = this.removeSurroundingWhitespace(value);
                    b = value.split(" ")[0];
                    try {
                        this.externalLength = Integer.parseInt(b);
                    }
                    catch (Exception e) {
                        logger.warning("Could not parse number from " + b);
                    }
                    continue;
                }
                if (this.startsWithOneOf(fieldName, this.noDecPlaces)) {
                    signPart = fieldName.split(",")[1];
                    if (this.startsWithOneOf(signPart = signPart.replaceAll("^ *", ""), this.hasNoSignWords)) {
                        this.sign = "false";
                        continue;
                    }
                    this.sign = "true";
                    continue;
                }
                if (fieldName.startsWith("0")) {
                    this.decimals = fieldName.split(" ")[0];
                    signPart = fieldName.split(",")[1];
                    if (this.startsWithOneOf(signPart = signPart.replaceAll("^ *", ""), this.hasNoSignWords)) {
                        this.sign = "false";
                        continue;
                    }
                    this.sign = "true";
                    continue;
                }
                this.name = this.removeSurroundingWhitespace(fieldName);
                this.documentation = value.replaceAll("<b>", "");
                this.documentation = this.documentation.replaceAll("</b>", "");
                this.documentation = this.removeSurroundingWhitespace(this.documentation);
            }
        }
        catch (Exception e) {
            logger.warning("could not parse FieldMeta: " + e.getClass().getName() + " in " + s);
        }
    }

    private String[] binarySplit(String what, String separator) {
        int pos = what.indexOf(separator);
        String left = what.substring(0, pos);
        String right = what.substring(pos + separator.length(), what.length());
        return new String[]{left, right};
    }

    private String removeSurroundingWhitespace(String s) {
        String b = s;
        b = b.replaceAll(" *$", "");
        b = b.replaceAll("^ *", "");
        return b;
    }

    private boolean isOneOf(String s, String[] sa) {
        for (int i = 0; i < sa.length; ++i) {
            if (s.compareToIgnoreCase(sa[i]) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean startsWithOneOf(String s, String[] sa) {
        for (int i = 0; i < sa.length; ++i) {
            if (!s.startsWith(sa[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FieldMeta ");
        sb.append(this.name);
        sb.append(" (");
        sb.append("documentation='").append(this.documentation).append("'");
        sb.append(", internal data type=").append(this.internalDataType);
        sb.append(", decimals=").append(this.decimals);
        sb.append(", sign=").append(this.sign);
        sb.append(", internal length=").append(this.internalLength);
        sb.append(", external length=").append(this.externalLength);
        sb.append(", offset=").append(this.offset);
        sb.append(", position in segment=").append(this.positionInSegment);
        sb.append(")");
        return sb.toString();
    }
}

