/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.BuilderFatalError;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.build.event.BuildProcessStartEvent;
import ch.e2e.builder.compiler.document.importer.ExtensionElement;
import ch.e2e.builder.compiler.document.importer.ImportException;
import ch.e2e.builder.compiler.document.importer.ImportTransaction;
import ch.e2e.builder.compiler.document.importer.ImporterData;
import ch.e2e.builder.compiler.document.importer.Logging;
import ch.e2e.builder.compiler.error.ImportFatalError;
import ch.e2e.builder.compiler.tools.TransformerFactory;
import ch.e2e.builder.compiler.uml.DataModel;
import ch.e2e.builder.compiler.xsltinterface.XSLTInput;
import ch.e2e.dom.DomUtilities;
import ch.e2e.event.EventController;
import ch.e2e.io.ZipUtilities;
import ch.e2e.transformer.TransformerLoadException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class ScriptImportTransaction
extends ImportTransaction {
    public static String IMPORT_DATA_ALIASES = "import.data.aliases";
    private HashMap<String, Object> transformParameters = new HashMap();

    protected String getScript() {
        return "java2xmi";
    }

    protected void setExtensionsParameters(DataModel dataModel) {
        for (String key : this.transformParameters.keySet()) {
            dataModel.putExtensionParameter(key, this.transformParameters.get(key));
        }
    }

    protected void putTransformParameter(String name, Object value) {
        this.transformParameters.put(name, value);
    }

    protected Object getTransformParameter(String name) {
        return this.transformParameters.get(name);
    }

    protected Map<String, Object> getTransformParameters() {
        return this.transformParameters;
    }

    protected Map<String, Object> getDefaultExtensionParameters() {
        return new HashMap<String, Object>();
    }

    protected Map<String, Object> readExtensionsParameters(File file) {
        if (file.exists()) {
            return this.readExtensionsParameters(ExtensionElement.getExtensionImportedElement(file));
        }
        return new HashMap<String, Object>();
    }

    protected Map<String, Object> readExtensionsParameters(Element element) {
        return new HashMap<String, Object>();
    }

    protected File[] transform(HashMap<String, Document> documents, ImporterData importerData, String extension) {
        File[] result = new File[documents.size()];
        try {
            EventController.fire((EventObject)new BuildProcessStartEvent(this, null));
            int i = 0;
            for (String name : documents.keySet()) {
                DOMResult resultDocument = this.transform(this.getScript(), documents.get(name), name);
                result[i++] = this.writeXMI(resultDocument, importerData.getDestination().getParentFile(), name + extension);
            }
        }
        catch (TransformerConfigurationException ex) {
            Logging.logger.severe(ex.getLocalizedMessage());
        }
        catch (TransformerLoadException ex) {
            Logging.logger.severe(ex.getLocalizedMessage());
            ex.getTargetException().printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportException(ex));
        }
        return result;
    }

    protected void transform(Document document, File destination, String filename) {
        try {
            EventController.fire((EventObject)new BuildProcessStartEvent(this, null));
            DOMResult result = this.transform(this.getScript(), document, filename);
            this.writeXMI((Document)result.getNode(), destination);
        }
        catch (TransformerConfigurationException ex) {
            Logging.logger.severe(ex.getLocalizedMessage());
        }
        catch (TransformerLoadException ex) {
            Logging.logger.severe(ex.getLocalizedMessage());
            ex.getTargetException().printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportException(ex));
        }
    }

    protected void transform(Document document, ImporterData importerData) {
        try {
            EventController.fire((EventObject)new BuildProcessStartEvent(this, null));
            DOMResult result = this.transform(this.getScript(), document, importerData.getFilename());
            this.writeXMI(result, importerData);
        }
        catch (TransformerConfigurationException ex) {
            Logging.logger.severe(ex.getLocalizedMessage());
        }
        catch (TransformerLoadException ex) {
            Logging.logger.severe(ex.getLocalizedMessage());
            ex.getTargetException().printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportException(ex));
        }
    }

    protected Document transform(Document document) {
        Document result = null;
        try {
            EventController.fire((EventObject)new BuildProcessStartEvent(this, null));
            result = (Document)this.transform(new DOMSource(document), this.getScript()).getNode();
        }
        catch (TransformerConfigurationException ex) {
            Logging.logger.severe(ex.getLocalizedMessage());
        }
        catch (TransformerLoadException ex) {
            Logging.logger.severe(ex.getLocalizedMessage());
            ex.getTargetException().printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportException(ex));
        }
        return result;
    }

    protected Document transformMDImportDocument(File srcFile, String fileName, String importer) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        XSLTInput.setImportSource(fileName);
        Document source = this.getDocument(srcFile, false);
        String namespace = source.getDocumentElement().getAttribute("xmlns:xmi");
        if (namespace.equals("http://schema.omg.org/spec/XMI/2.1")) {
            source = this.getDocument(srcFile, true);
        } else {
            source.getDocumentElement().setAttribute("fileid", "12345");
            source.getDocumentElement().setAttribute("xmlns:xmi", "http://schema.omg.org/spec/XMI/2.1");
            source.getDocumentElement().setAttribute("xmlns:uml", "http://www.omg.org/spec/UML/20090901");
            source.getDocumentElement().setAttribute("xmlns:MagicDraw_Profile", "http://www.magicdraw.com/schemas/MagicDraw_Profile.xmi");
            File tmpFile = File.createTempFile("xmiDoc", ".xml");
            tmpFile.deleteOnExit();
            DomUtilities.serialize((File)tmpFile, (Document)source, (boolean)true);
            source = this.getDocument(tmpFile, true);
        }
        return this.transform(source, importer, fileName);
    }

    private Document getDocument(File srcFile, boolean namespaceAware) throws IOException, ParserConfigurationException, SAXException {
        Document source;
        try {
            source = ZipUtilities.getZippedDocumentFromFile((File)srcFile, (boolean)false, (boolean)false, (boolean)namespaceAware);
        }
        catch (ZipException zipEx) {
            source = DomUtilities.parse((File)srcFile, (boolean)false, (boolean)false, (boolean)namespaceAware);
        }
        return source;
    }

    protected Document transform(Document src, String script, String filename) {
        Document result = null;
        try {
            EventController.fire((EventObject)new BuildProcessStartEvent(this, null));
            DOMSource source = new DOMSource(src);
            result = (Document)this.transform(source, script).getNode();
            this.printSourceDocument(result, filename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportException(ex));
        }
        return result;
    }

    protected Document transform(File src, String script, String filename) {
        try {
            return this.transform(src.toURI().toURL(), script, filename);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            XSLTErrorHandler.getInstance().fatalError((BuilderFatalError)new ImportFatalError(ex));
            return null;
        }
    }

    protected Document transform(URL url, String script, String filename) {
        Document result = null;
        try {
            EventController.fire((EventObject)new BuildProcessStartEvent(this, null));
            StreamSource source = new StreamSource(url.openConnection().getInputStream(), url.toString());
            result = (Document)this.transform(source, script).getNode();
            this.printSourceDocument(result, filename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XSLTErrorHandler.getInstance().fatalError((BuilderFatalError)new ImportFatalError(ex));
        }
        return result;
    }

    protected void transform(File srcfile, ImporterData importerData) {
        try {
            EventController.fire((EventObject)new BuildProcessStartEvent(this, null));
            Document result = this.transform(this.getScript(), srcfile);
            this.writeXMI(result, importerData.getDestination());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportException(ex));
        }
    }

    private void writeXMI(DOMResult result, ImporterData importerData) throws TransformerException, IOException {
        this.writeXMI((Document)result.getNode(), importerData.getDestination());
    }

    private File writeXMI(DOMResult result, File folder, String filename) throws TransformerException, IOException {
        return this.writeXMI((Document)result.getNode(), new File(folder, filename));
    }

    private File writeXMI(Document resultDocument, File destination) throws TransformerException, IOException {
        String filename = destination.getName();
        String lowerPath = filename.toLowerCase();
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        if (lowerPath.endsWith(".xml.zip")) {
            DomUtilities.serializeToZip((File)destination, (Document)resultDocument, (boolean)true, (ClassLoader)this.getClass().getClassLoader());
        } else {
            DomUtilities.serialize((File)destination, (Document)resultDocument, (boolean)true, (ClassLoader)this.getClass().getClassLoader());
        }
        return destination;
    }

    protected Document transform(String script, File srcfile) throws TransformerLoadException, TransformerException {
        DOMResult result = null;
        if (srcfile.exists()) {
            try {
                FileInputStream fileIn = new FileInputStream(srcfile);
                StreamSource source = new StreamSource(fileIn, srcfile.getAbsolutePath());
                result = this.transform(source, script);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return result == null ? null : (Document)result.getNode();
    }

    protected DOMResult transform(String script, Document document, String filename) throws TransformerLoadException, TransformerException {
        this.printSourceDocument(document, filename);
        DOMSource source = new DOMSource(document);
        return this.transform(source, script);
    }

    protected Document transform(URL url, ImporterData importerData) {
        DOMResult result = null;
        try {
            EventController.fire((EventObject)new BuildProcessStartEvent(this, null));
            StreamSource source = new StreamSource(url.openConnection().getInputStream(), url.toString());
            result = this.transform(source, this.getScript());
            this.writeXMI(result, importerData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportException(ex));
        }
        return result == null ? null : (Document)result.getNode();
    }

    protected DOMResult transform(Source source, String script) throws TransformerLoadException, TransformerException {
        DOMResult result = new DOMResult();
        Transformer transformer = TransformerFactory.getInstance().getTransformer(script, new TransformerErrorListener());
        for (Map.Entry<String, Object> parameter : this.transformParameters.entrySet()) {
            transformer.setParameter(parameter.getKey(), parameter.getValue());
        }
        transformer.transform(source, result);
        return result;
    }

    protected void printSourceDocument(Document sourceDocument, String importFilename) {
        String development;
        if (sourceDocument != null && (development = System.getProperty("ch.e2e.builder.development")) != null && development.equalsIgnoreCase("true")) {
            String filename = importFilename + ".import";
            try {
                File developmentDir = new File(System.getProperty("ch.e2e.builder.development.dir"));
                if (!developmentDir.exists()) {
                    developmentDir.mkdirs();
                }
                File file = new File(developmentDir, filename);
                System.out.println("Writing " + file);
                DomUtilities.serialize((File)file, (Document)sourceDocument, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void transactionFinished(ImporterData importerData) {
    }

    private class TransformerErrorListener
    implements ErrorListener {
        private TransformerErrorListener() {
        }

        @Override
        public void warning(TransformerException transformerException) throws TransformerException {
            Logging.logger.severe(transformerException.getMessageAndLocation());
        }

        @Override
        public void error(TransformerException transformerException) throws TransformerException {
            Logging.logger.severe(transformerException.getMessageAndLocation());
        }

        @Override
        public void fatalError(TransformerException transformerException) throws TransformerException {
            Logging.logger.severe(transformerException.getMessageAndLocation());
        }
    }
}

