/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.XSLTErrorHandler;
import ch.e2e.builder.compiler.document.importer.ImportContainer;
import ch.e2e.builder.compiler.document.importer.ImportModel;
import ch.e2e.builder.compiler.document.importer.ImportSource;
import ch.e2e.builder.compiler.document.importer.Logging;
import ch.e2e.builder.compiler.error.ImportError;
import ch.e2e.builder.compiler.uml.BridgeAssociation;
import ch.e2e.builder.compiler.uml.BridgeAttribute;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeEnumeration;
import ch.e2e.builder.compiler.uml.BridgeInstance;
import ch.e2e.builder.compiler.uml.BridgeNode;
import ch.e2e.builder.compiler.uml.BridgeNodeInstance;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.BridgeOwnedEnd;
import ch.e2e.builder.compiler.uml.BridgePackage;
import ch.e2e.builder.compiler.uml.BridgeParameter;
import ch.e2e.builder.compiler.uml.BridgeRealization;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Constraint;
import ch.e2e.builder.compiler.uml.DataModel;
import ch.e2e.builder.compiler.uml.DeploymentElement;
import ch.e2e.builder.compiler.uml.Direction;
import ch.e2e.builder.compiler.uml.Generalization;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.builder.compiler.uml.Multiplicity;
import ch.e2e.builder.compiler.uml.NoSuchPropertyException;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.TypedElement;
import ch.e2e.builder.compiler.uml.UmlElement;
import ch.e2e.builder.compiler.utils.StringUtils;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class IDLImportSource
extends ImportSource
implements ImportContainer {
    private boolean createTestModel;
    private HashMap<String, IDLImportSource> importedElements;
    private Module module;
    private ImportModel importModel;
    private String name;
    private Element idl;
    private ArrayList<String> importedModels;
    private Helpers helpers;
    private File importFolder;
    private DataModel dataModel;
    private ElementMaps elementMaps;

    public IDLImportSource(String name, Element idl, File importFolder, Helpers helpers) {
        this(name, importFolder, helpers);
        this.idl = idl;
        this.readImportedModels(idl.getElementsByTagName("IDLImport"));
    }

    protected IDLImportSource(String name, File importFolder, Helpers helpers) {
        this.helpers = helpers;
        this.importFolder = importFolder;
        this.importedElements = new HashMap();
        this.importModel = new ImportModel(name);
        this.name = name;
    }

    @Override
    public String getDevelopmentFilename() {
        return this.getName() + "idl.dev";
    }

    public File getImportFolder() {
        return this.importFolder;
    }

    public Helpers getHelpers() {
        return this.helpers;
    }

    public boolean isCreateTestModel() {
        return this.createTestModel;
    }

    public void setCreateTestModel(boolean createTestModel) {
        this.createTestModel = createTestModel;
    }

    @Override
    public void addImportedElement(IDLImportSource source) {
        if (source != null) {
            this.importedElements.put(source.getName(), source);
        }
    }

    @Override
    public Collection<IDLImportSource> getImportedElements() {
        return this.importedElements.values();
    }

    @Override
    public ImportSource getImportedElement(String name) {
        return this.importedElements.get(name);
    }

    @Override
    public boolean containsImport(String name) {
        return this.importedElements.containsKey(name);
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public Element getIdl() {
        return this.idl;
    }

    @Override
    public ImportModel getImportModel() {
        return this.importModel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ArrayList<String> getImportedModels() {
        return this.importedModels;
    }

    private void readImportedModels(NodeList imports) {
        this.importedModels = new ArrayList();
        if (imports != null) {
            ArrayList<Element> elementsToRemove = new ArrayList<Element>();
            int length = imports.getLength();
            for (int i = 0; i < length; ++i) {
                Element child = (Element)imports.item(i);
                elementsToRemove.add(child);
                this.importedModels.add(child.getAttribute("sourceLocation"));
            }
            for (Element element : elementsToRemove) {
                element.getParentNode().removeChild(element);
            }
        }
    }

    public DataModel getDataModel() {
        this.generateDataModelAndElementsMap();
        return this.dataModel;
    }

    public ElementMaps getElementMaps() {
        this.generateDataModelAndElementsMap();
        return this.elementMaps;
    }

    private synchronized void generateDataModelAndElementsMap() {
        if (this.dataModel == null) {
            this.elementMaps = new ElementMaps();
            this.getHelpers().getXmiIDFactory().setGlobalPrefix(this.getName() + '_');
            this.dataModel = this.createDataModel();
            this.dataModel.setNamedBasedOperationSyntax(this.isNamedBasedOperationSyntax());
            BridgePackage rootPackage = this.fillDataModel(this.dataModel, this.elementMaps);
            BridgePackage componentPackage = this.getHelpers().getPackagesFactory().createPackages("Component View", rootPackage, this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
            if (this.getImportModel().isCreate()) {
                this.createProxyComponents(this.dataModel, componentPackage);
            }
            this.getImportModel().setDataModel(this.dataModel);
        }
    }

    protected void createProxyComponents(DataModel dataModel, BridgePackage components) {
    }

    protected DataModel createDataModel() {
        DataModel dataModel = new DataModel(this.getName(), "IDL_IMPORT_", this.getHelpers());
        Module module = this.getHelpers().getModuleFactory().getModule(new File(this.getImportFolder(), this.getName() + ".import.xml"), dataModel.getModelId());
        dataModel.setModule(module);
        return dataModel;
    }

    protected BridgePackage fillDataModel(DataModel dataModel, ElementMaps elementMaps) {
        Element libraryInfo = this.getIdl();
        HashMap<String, BridgeClass> classes = new HashMap<String, BridgeClass>();
        BridgePackage rootPackage = this.getHelpers().getPackagesFactory().createPackages(dataModel.getName(), dataModel.getModel().getOrigin(), this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
        dataModel.addPackage(rootPackage);
        rootPackage.setModule(dataModel.getModule());
        dataModel.addSharedPackage(rootPackage);
        NodeList children = libraryInfo.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("package")) continue;
            this.createPackage((Element)child, dataModel, rootPackage, classes, elementMaps);
        }
        this.addClassesToDataModel(dataModel, elementMaps.allElements);
        return rootPackage;
    }

    protected void addClassesToDataModel(DataModel dataModel, HashMap<Object, UmlElement> classes) {
        for (UmlElement clazz : classes.values()) {
            if (!(clazz instanceof BridgeClass) && !(clazz instanceof DeploymentElement)) continue;
            dataModel.addElement(clazz);
        }
    }

    private BridgePackage createPackage(Element packageElement, DataModel dataModel, BridgePackage rootPackage, HashMap<String, BridgeClass> classes, ElementMaps elementMaps) {
        String name = this.removeNamespaceURN(packageElement.getAttribute("name"));
        BridgePackage bridgePackage = this.getHelpers().getPackagesFactory().createPackages(name, rootPackage, this.getHelpers().getStereotypeFactory().getStereotype("Repository"));
        dataModel.addPackage(bridgePackage);
        elementMaps.allElements.put(packageElement, bridgePackage);
        bridgePackage.setModule(dataModel.getModule());
        this.addChildren(packageElement.getChildNodes(), bridgePackage, dataModel, classes, elementMaps);
        while (bridgePackage.getOwningPackage() != null && !bridgePackage.getOwningPackage().equals(dataModel.getModel().getOrigin())) {
            bridgePackage = bridgePackage.getOwningPackage();
        }
        return bridgePackage;
    }

    protected String removeNamespaceURN(String value) {
        if (value.lastIndexOf(58) != -1) {
            value = value.substring(value.lastIndexOf(58) + 1);
        }
        int index = value.indexOf(46);
        while (index != -1) {
            String post;
            String pre;
            if (index > 0 && value.charAt(index - 1) == '\\') {
                pre = value.substring(0, index - 1);
                post = value.substring(index + 1);
                value = pre + '.' + post;
                --index;
            } else {
                pre = value.substring(0, index);
                post = value.substring(index + 1);
                value = pre + '/' + post;
            }
            index = value.indexOf(46, index + 1);
        }
        return value;
    }

    private void addChildren(NodeList children, BridgePackage owningPackage, DataModel dataModel, HashMap<String, BridgeClass> classes, ElementMaps elementMaps) {
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (node.getNamespaceURI() != null && node.getNamespaceURI().equals("http://e2e.ch/bridge/profile")) continue;
            if (node.getNodeName().equals("Enumeration")) {
                this.addEnumeration((Element)node, owningPackage, dataModel, classes, elementMaps);
                continue;
            }
            if (node.getNodeName().equals("package")) {
                this.createPackage((Element)node, dataModel, owningPackage, classes, elementMaps);
                continue;
            }
            if (node.getNodeName().equals("Artifact")) {
                this.createArtifact((Element)node, dataModel, owningPackage, elementMaps);
                continue;
            }
            if (node.getNodeName().equals("InstanceSpecification")) {
                this.createBridgeInstance((Element)node, dataModel, owningPackage, elementMaps);
                continue;
            }
            if (node.getNodeName().equals("NodeInstance")) {
                this.createNodeInstance((Element)node, dataModel, owningPackage, elementMaps);
                continue;
            }
            if (!(node instanceof Element)) continue;
            this.addClass((Element)node, owningPackage, dataModel, classes, elementMaps);
        }
    }

    private BridgeClass addClass(Element classElement, BridgePackage aPackage, DataModel dataModel, HashMap<String, BridgeClass> classes, ElementMaps elementMaps) {
        BridgeClass clazz = this.createBridgeClass(classElement, aPackage, dataModel, elementMaps);
        NodeList children = classElement.getChildNodes();
        this.initializeClass(clazz, classElement, children, dataModel, classes, elementMaps);
        return clazz;
    }

    private void initializeClass(BridgeClass clazz, Element classElement, NodeList children, DataModel dataModel, HashMap<String, BridgeClass> classes, ElementMaps elementMaps) {
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (node.getNodeName().equals("operation")) {
                this.addOperation((Element)node, clazz, classElement, elementMaps, dataModel.isNamedBasedOperationSyntax());
                continue;
            }
            if (node.getNodeName().equals("attribute")) {
                this.addAttribute((Element)node, clazz, elementMaps);
                continue;
            }
            if (node.getNodeName().equals("generalization")) {
                elementMaps.generals.put((Element)node, clazz);
                continue;
            }
            if (node.getNodeName().equals("interfaceRealization")) {
                elementMaps.interfaceRealizations.put((Element)node, clazz);
                continue;
            }
            if (node.getNodeName().equals("Constraint")) {
                this.addConstraint((Element)node, clazz, elementMaps, dataModel.getModule());
                continue;
            }
            if (node.getNodeName().equals("realization")) {
                elementMaps.realizations.put((Element)node, clazz);
                continue;
            }
            if (!node.getNodeName().equals("Class")) continue;
            BridgeClass embeddedClass = this.createBridgeClass((Element)node, null, dataModel, elementMaps);
            clazz.addChild(embeddedClass);
            this.initializeClass(embeddedClass, (Element)node, node.getChildNodes(), dataModel, classes, elementMaps);
        }
        classes.put(classElement.getAttribute("id"), clazz);
        elementMaps.allClasses.put(classElement.getAttribute("id"), clazz);
        elementMaps.allReferableElements.put(classElement.getAttribute("id"), clazz);
        elementMaps.allElements.put(classElement, clazz);
    }

    private void addConstraint(Element element, BridgeClass clazz, ElementMaps elementMaps, Module module) {
        Constraint constraint = new Constraint(this.getHelpers());
        constraint.setSpecification(element.getAttribute("body"), element.getAttribute("type"), element.getAttribute("language"));
        clazz.addChild(constraint);
        constraint.setModule(module);
        elementMaps.constraints.put(element, constraint);
    }

    private void addOperation(Element operationElement, BridgeClass clazz, Element classElement, ElementMaps elementMaps, Boolean nameBasedOperationSyntax) {
        BridgeOperation operation = new BridgeOperation(operationElement.getAttribute("name"), this.createComment(operationElement), this.getHelpers());
        operation.setNamedBasedOperationSyntax(nameBasedOperationSyntax);
        operation.setStatic(DomUtilities.getBoolean((Element)operationElement, (String)"isStatic", (boolean)false));
        operation.setAbstract(DomUtilities.getBoolean((Element)operationElement, (String)"isAbstract", (boolean)false));
        operation.setModule(clazz.getModule());
        this.addStereotypes(operationElement, operation, elementMaps);
        NodeList children = operationElement.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equals("parameter")) continue;
            this.addParameter((Element)node, operation, elementMaps, nameBasedOperationSyntax);
        }
        clazz.addOperation(operation);
        elementMaps.allElements.put(operationElement, operation);
        elementMaps.allReferableElements.put(classElement.getAttribute("id") + ":operation:" + operation.getSignature(), operation);
    }

    private void addParameter(Element parameterElement, BridgeOperation operation, ElementMaps elementMaps, Boolean nameBasedOperationSyntax) {
        String name = parameterElement.getAttribute("name");
        String direction = parameterElement.getAttribute("direction");
        BridgeParameter parameter = new BridgeParameter(name, Direction.getDirection(direction), this.createComment(parameterElement), this.getHelpers());
        if (!nameBasedOperationSyntax.booleanValue()) {
            String baseType = parameterElement.getAttribute("basetype");
            String type = parameterElement.getAttribute("type");
            BridgeClass typeClass = new BridgeClass(baseType != null && !baseType.equals("") ? baseType : type, null, null, this.getHelpers());
            parameter.setTypeClass(typeClass);
        }
        parameter.setModule(operation.getModule());
        operation.addParameter(parameter);
        this.addStereotypes(parameterElement, parameter, elementMaps);
        if (parameterElement.hasAttribute("lowerValue") || parameterElement.hasAttribute("upperValue")) {
            int lower = DomUtilities.getInt((Element)parameterElement, (String)"lowerValue", (int)1);
            int upper = DomUtilities.getInt((Element)parameterElement, (String)"upperValue", (int)1);
            parameter.setMultiplicity(Multiplicity.createMultiplicity(lower, upper));
        }
        elementMaps.typedElements.put(parameterElement, parameter);
        elementMaps.allElements.put(parameterElement, parameter);
    }

    private void addAttribute(Element attributeElement, BridgeClass clazz, ElementMaps elementMaps) {
        NodeList defaultValues;
        BridgeAttribute attribute = new BridgeAttribute(attributeElement.getAttribute("name"), this.createComment(attributeElement), null, this.getHelpers());
        clazz.addAttribute(attribute);
        attribute.setModule(clazz.getModule());
        this.addStereotypes(attributeElement, attribute, elementMaps);
        if (attributeElement.hasAttribute("lowerValue") || attributeElement.hasAttribute("upperValue")) {
            int lower = DomUtilities.getInt((Element)attributeElement, (String)"lowerValue", (int)1);
            int upper = DomUtilities.getInt((Element)attributeElement, (String)"upperValue", (int)1);
            attribute.setMultiplicity(Multiplicity.createMultiplicity(lower, upper));
        }
        if ((defaultValues = attributeElement.getElementsByTagName("defaultValue")) != null && defaultValues.getLength() == 1) {
            Element defaultValue = (Element)defaultValues.item(0);
            attribute.setDefaultValue(defaultValue.getAttribute("value"), defaultValue.getAttribute("xmi:type"));
        }
        this.setAssociation(attributeElement, attribute, clazz);
        elementMaps.typedElements.put(attributeElement, attribute);
        elementMaps.allElements.put(attributeElement, attribute);
    }

    private void setAssociation(Element attributeElement, BridgeAttribute attribute, BridgeClass clazz) {
        if (DomUtilities.getBoolean((Element)attributeElement, (String)"isAssociation", (boolean)false)) {
            BridgeAssociation association = new BridgeAssociation(attribute.getName(), this.getHelpers());
            BridgePackage owningPackage = null;
            for (UmlElement clazzParent = clazz; owningPackage == null && clazzParent != null; clazzParent = clazzParent.getParent()) {
                owningPackage = clazzParent.getOwningPackage();
            }
            association.setOwningPackage(owningPackage);
            association.setModule(clazz.getModule());
            BridgeOwnedEnd ownedEnd = new BridgeOwnedEnd(association.getXmiID(), this.getHelpers());
            ownedEnd.setTypeClass(clazz);
            ownedEnd.setModule(clazz.getModule());
            association.addOwnedEnd(ownedEnd);
            association.addMemberEnd(attribute.getXmiID());
            association.addMemberEnd(ownedEnd.getXmiID());
            attribute.setAssociation(association);
        }
    }

    private BridgeClass createBridgeClass(Element classElement, BridgePackage aPackage, DataModel dataModel, ElementMaps elementMaps) {
        String name = classElement.getAttribute("name");
        BridgeClass clazz = new BridgeClass(name, this.createComment(classElement), null, this.getHelpers());
        clazz.setOwningPackage(aPackage);
        clazz.setModule(dataModel.getModule());
        this.addStereotypes(classElement, clazz, elementMaps);
        clazz.setBaseclass(classElement.getNodeName());
        clazz.setAbstract(DomUtilities.getBoolean((Element)classElement, (String)"isAbstract", (boolean)false));
        clazz.setBinding(classElement.hasAttribute("binding") ? classElement.getAttribute("binding") : null);
        return clazz;
    }

    private UmlElement createBridgeInstance(Element instanceElement, DataModel dataModel, BridgePackage owningPackage, ElementMaps elementMaps) {
        String name = instanceElement.getAttribute("name");
        Comment comment = this.createComment(instanceElement);
        BridgeInstance instance = new BridgeInstance(name, comment, this.getHelpers());
        this.addStereotypes(instanceElement, instance, elementMaps);
        NodeList children = instanceElement.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equals("classifier")) continue;
            elementMaps.classifiers.put((Element)node, instance);
        }
        instance.setModule(dataModel.getModule());
        instance.setOwningPackage(owningPackage);
        elementMaps.allElements.put(instanceElement, instance);
        elementMaps.allClasses.put(instanceElement.getAttribute("id"), instance);
        return instance;
    }

    private UmlElement createNodeInstance(Element instanceElement, DataModel dataModel, BridgePackage owningPackage, ElementMaps elementMaps) {
        String name = instanceElement.getAttribute("name");
        String classifierName = instanceElement.getAttribute("classifierName");
        BridgeNode classifier = this.getHelpers().getElementHelper().findServer(classifierName);
        Comment comment = this.createComment(instanceElement);
        BridgeNodeInstance instance = new BridgeNodeInstance(name, comment, classifier, this.getHelpers());
        this.addStereotypes(instanceElement, instance, elementMaps);
        NodeList children = instanceElement.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equals("Deployment")) continue;
            elementMaps.deployments.put((Element)node, instance);
        }
        instance.setModule(dataModel.getModule());
        instance.setOwningPackage(owningPackage);
        elementMaps.allElements.put(instanceElement, instance);
        return instance;
    }

    private void addEnumeration(Element classElement, BridgePackage aPackage, DataModel dataModel, HashMap<String, BridgeClass> classes, ElementMaps elementMaps) {
        String name = classElement.getAttribute("name");
        BridgeEnumeration enumeration = new BridgeEnumeration(name, this.createComment(classElement), null, this.getHelpers());
        enumeration.setOwningPackage(aPackage);
        enumeration.setModule(dataModel.getModule());
        NodeList children = classElement.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (node.getNamespaceURI() != null && node.getNamespaceURI().equals("http://e2e.ch/bridge/profile")) {
                this.addStereotype((Element)node, enumeration, elementMaps);
                continue;
            }
            if (!node.getNodeName().equals("literal")) continue;
            enumeration.addLiteral(((Element)node).getAttribute("value"));
        }
        classes.put(classElement.getAttribute("id"), enumeration);
        elementMaps.allClasses.put(classElement.getAttribute("id"), enumeration);
        elementMaps.allElements.put(classElement, enumeration);
    }

    private UmlElement createArtifact(Element artifactElement, DataModel dataModel, BridgePackage owningPackage, ElementMaps elementMaps) {
        String name = artifactElement.getAttribute("name");
        Comment comment = this.createComment(artifactElement);
        ArrayList<BridgeStereotype> stereotypes = this.getStereotypes(artifactElement);
        DeploymentElement artifact = new DeploymentElement(name, comment, this.getHelpers());
        this.addStereotypes(artifactElement, artifact, elementMaps);
        NodeList children = artifactElement.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (node.getNodeName().equals("nestedArtifact")) {
                artifact.addChild(this.createArtifact((Element)node, dataModel, null, elementMaps));
                continue;
            }
            if (!node.getNodeName().equals("manifestation")) continue;
            elementMaps.manifestations.put((Element)node, artifact);
        }
        elementMaps.allClasses.put(artifactElement.getAttribute("id"), artifact);
        artifact.setModule(dataModel.getModule());
        artifact.setOwningPackage(owningPackage);
        elementMaps.allElements.put(artifactElement, artifact);
        if (this.containsAliasType(stereotypes)) {
            artifact.setBinding(artifactElement.hasAttribute("binding") ? artifactElement.getAttribute("binding") : null);
            elementMaps.aliases.put(artifactElement, artifact);
        } else {
            elementMaps.allElements.put(artifactElement, artifact);
        }
        return artifact;
    }

    private boolean containsAliasType(ArrayList<BridgeStereotype> stereotypes) {
        boolean result = false;
        int typesLength = stereotypes.size();
        for (int j = 0; j < typesLength && !result; ++j) {
            result = stereotypes.get(j).isDerivedFrom(this.getHelpers().getStereotypeFactory().getStereotype("BackendAlias")) || stereotypes.get(j).equals(this.getHelpers().getStereotypeFactory().getStereotype("Alias"));
        }
        return result;
    }

    private void addStereotypes(Element element, UmlElement umlElement, ElementMaps elementMaps) {
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (node.getNamespaceURI() == null || !node.getNamespaceURI().equals("http://e2e.ch/bridge/profile")) continue;
            this.addStereotype((Element)node, umlElement, elementMaps);
        }
    }

    private void addStereotype(Element node, UmlElement umlElement, ElementMaps elementMaps) {
        BridgeStereotype stereotype = this.getHelpers().getStereotypeFactory().getStereotype(node.getLocalName());
        if (stereotype != null) {
            NodeList enumeration;
            umlElement.addStereotype(stereotype);
            umlElement.setStereotype(stereotype);
            NamedNodeMap attributes = node.getAttributes();
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                try {
                    if (!stereotype.getCustomization().hasPropertyDefinition(attribute.getName())) continue;
                    umlElement.setPropertyValue(attribute.getName(), attribute.getValue());
                    elementMaps.properties.put(umlElement.getProperty(attribute.getName()), node);
                    continue;
                }
                catch (Exception e) {
                    Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    Logging.logger.throwing(this.getClass().getName(), "", e);
                }
            }
            NodeList children = node.getChildNodes();
            length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                Element element = (Element)child;
                try {
                    String propertyName = element.getLocalName();
                    if (!stereotype.getCustomization().hasPropertyDefinition(propertyName)) continue;
                    if (stereotype.getCustomization().getPropertyDefinition(propertyName).getMultiplicity().multipleInstancesAllowed()) {
                        ArrayList<String> value = (ArrayList<String>)umlElement.getPropertyValue(propertyName);
                        if (value == null) {
                            value = new ArrayList<String>();
                        }
                        if (element.getTextContent() != null) {
                            value.add(element.getTextContent());
                        }
                        umlElement.setPropertyValue(propertyName, value);
                    } else {
                        umlElement.setPropertyValue(propertyName, element.getNodeValue());
                    }
                    elementMaps.properties.put(umlElement.getProperty(propertyName), node);
                    continue;
                }
                catch (Exception e) {
                    Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                    Logging.logger.throwing(this.getClass().getName(), "", e);
                }
            }
            if (stereotype.getCustomization().hasPropertyDefinition("enumeration") && (enumeration = node.getElementsByTagName("enumeration")) != null && enumeration.getLength() > 0) {
                ArrayList<String> value = new ArrayList<String>();
                length = enumeration.getLength();
                for (int i = 0; i < length; ++i) {
                    Node literal = enumeration.item(i);
                    String literalValue = DomUtilities.getTextValue((Element)((Element)literal), null);
                    if (literalValue == null) continue;
                    value.add(literalValue);
                }
                umlElement.setPropertyValueQuietly("enumeration", value);
                try {
                    elementMaps.properties.put(umlElement.getProperty("enumeration"), node);
                }
                catch (NoSuchPropertyException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private ArrayList<BridgeStereotype> getStereotypes(Element element) {
        ArrayList<BridgeStereotype> result = new ArrayList<BridgeStereotype>();
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (node.getNamespaceURI() == null || !node.getNamespaceURI().equals("http://e2e.ch/bridge/profile")) continue;
            result.add(this.getHelpers().getStereotypeFactory().getStereotype(node.getLocalName()));
        }
        return result;
    }

    private Comment createComment(Element parent) {
        NodeList comments = parent.getElementsByTagName("comment");
        Comment comment = comments != null && comments.getLength() > 0 && comments.item(0).hasChildNodes() && comments.item(0).getFirstChild() instanceof Text ? new Comment(((Text)comments.item(0).getFirstChild()).getData(), this.getHelpers()) : new Comment("", this.getHelpers());
        return comment;
    }

    public String getTypeFromOriginalObject(Object element) {
        if (element instanceof Element) {
            return ((Element)element).getAttribute("type");
        }
        return "";
    }

    public String getArrayElementFromOriginalObject(Object element) {
        if (element instanceof Element) {
            NodeList children = ((Element)element).getChildNodes();
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = children.item(i);
                if (node.getNamespaceURI() == null || !node.getNamespaceURI().equals("http://e2e.ch/bridge/profile") || !node.getLocalName().equals("E2EArray") && !node.getLocalName().equals("E2EArrayParameter")) continue;
                return ((Element)node).getAttribute("arrayElement");
            }
        }
        return "";
    }

    protected UmlElement findType(Object element, HashMap<String, UmlElement> classes) {
        if (element instanceof Element) {
            return this.findType(((Element)element).getAttribute("type"), (Element)element, classes);
        }
        return null;
    }

    private UmlElement findType(String typeString, Element element, HashMap<String, UmlElement> classes) {
        UmlElement type;
        if (element.hasAttribute("basetype")) {
            String xmiId = typeString.contains("#") ? StringUtils.substringAfter(typeString, "#") : typeString;
            type = this.getHelpers().getElementHelper().findBaseType(element.getAttribute("basetype"), xmiId);
        } else {
            type = classes.get(typeString);
        }
        return type;
    }

    public void replaceUsingImportedClasses(HashMap<String, UmlElement> allClasses) {
        this.replaceGenerals(allClasses);
        this.replaceInterfaceRealizations(allClasses);
        this.replaceRealizations(allClasses);
        this.replaceManifestations(allClasses);
        this.replaceClassifiers(allClasses);
        this.replaceDeployments(allClasses);
        this.replaceConstrainedElements(allClasses);
        this.replaceProperties(allClasses);
        this.setTypes(allClasses);
    }

    private void replaceGenerals(HashMap<String, UmlElement> allClasses) {
        HashMap<Element, BridgeClass> children = this.elementMaps.generals;
        for (Element generalilzationElement : children.keySet()) {
            BridgeClass parentClass = (BridgeClass)this.findType(generalilzationElement, allClasses);
            if (parentClass == null) continue;
            BridgeClass childClass = children.get(generalilzationElement);
            Generalization generalization = new Generalization(parentClass, childClass, this.helpers);
            this.addStereotypes(generalilzationElement, generalization, this.elementMaps);
            childClass.addGeneral(generalization);
            this.elementMaps.allClasses.put(generalilzationElement.getAttribute("id"), generalization);
            this.getDataModel().addElement(generalization);
        }
    }

    private void replaceInterfaceRealizations(HashMap<String, UmlElement> allClasses) {
        for (Element realizationElement : this.getElementMaps().interfaceRealizations.keySet()) {
            BridgeClass realization = (BridgeClass)this.findType(realizationElement, allClasses);
            if (realization == null) continue;
            this.getElementMaps().interfaceRealizations.get(realizationElement).addRealization(realization);
        }
    }

    private void replaceRealizations(HashMap<String, UmlElement> allClasses) {
        for (Element realizationElement : this.getElementMaps().realizations.keySet()) {
            UmlElement classifier = this.findType(realizationElement, allClasses);
            if (classifier == null) continue;
            BridgeRealization realization = new BridgeRealization(classifier, this.helpers);
            this.getElementMaps().realizations.get(realizationElement).addChild(realization);
        }
    }

    private void replaceManifestations(HashMap<String, UmlElement> allClasses) {
        for (Element realizationElement : this.getElementMaps().manifestations.keySet()) {
            BridgeClass manifestation = (BridgeClass)this.findType(realizationElement, allClasses);
            if (manifestation == null) continue;
            this.getElementMaps().manifestations.get(realizationElement).setClassifier(manifestation);
        }
    }

    private void replaceClassifiers(HashMap<String, UmlElement> allClasses) {
        for (Element classifierElement : this.getElementMaps().classifiers.keySet()) {
            DeploymentElement manifestation = (DeploymentElement)this.findType(classifierElement, allClasses);
            if (manifestation == null) continue;
            this.getElementMaps().classifiers.get(classifierElement).setClassifierArtifact(manifestation);
        }
    }

    private void replaceDeployments(HashMap<String, UmlElement> allClasses) {
        for (Element classifierElement : this.getElementMaps().deployments.keySet()) {
            DeploymentElement deployment = (DeploymentElement)this.findType(classifierElement, allClasses);
            if (deployment == null) continue;
            this.getElementMaps().deployments.get(classifierElement).addChild(deployment);
        }
    }

    private void replaceConstrainedElements(HashMap<String, UmlElement> allClasses) {
        for (Element element : this.getElementMaps().constraints.keySet()) {
            UmlElement constrainedElement = this.findType(element.getAttribute("constrainedElement"), element, allClasses);
            if (constrainedElement == null) continue;
            this.getElementMaps().constraints.get(element).setConstrainedElement(constrainedElement);
        }
    }

    private void replaceProperties(HashMap<String, UmlElement> allClasses) {
        for (Property property : this.getElementMaps().properties.keySet()) {
            if (property.getType() == null || !UmlElement.class.isAssignableFrom(property.getType())) continue;
            Element stereotypeElement = this.getElementMaps().properties.get(property);
            String type = (String)property.getValue();
            UmlElement typeClass = this.findType(type, stereotypeElement, allClasses);
            if (typeClass == null || !property.getType().isAssignableFrom(typeClass.getClass())) continue;
            property.setValue(typeClass);
        }
    }

    private void setTypes(HashMap<String, UmlElement> allClasses) {
        for (Object element : this.getElementMaps().typedElements.keySet()) {
            TypedElement typedElement = this.getElementMaps().typedElements.get(element);
            BridgeClass type = (BridgeClass)this.findType(element, allClasses);
            if (type == null) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("name", typedElement.getName());
                XSLTErrorHandler.getInstance().error((AbstractBuilderError)new ImportError("library.import.type.not.found", parameters));
                continue;
            }
            typedElement.setTypeClass(type);
        }
    }

    public static class ElementMaps {
        public HashMap<String, UmlElement> allClasses = new HashMap();
        public HashMap<String, UmlElement> allReferableElements = new HashMap();
        public HashMap<Element, BridgeClass> generals = new HashMap();
        public HashMap<Element, BridgeClass> interfaceRealizations;
        public HashMap<Element, BridgeClass> realizations;
        public HashMap<Element, DeploymentElement> manifestations;
        public HashMap<Object, TypedElement> typedElements;
        public HashMap<Property, Element> properties;
        public HashMap<Object, UmlElement> allElements;
        public HashMap<Element, BridgeInstance> classifiers = new HashMap();
        public HashMap<Element, BridgeNodeInstance> deployments = new HashMap();
        public HashMap<Element, Constraint> constraints;
        public HashMap<Element, DeploymentElement> aliases;

        public ElementMaps() {
            this.interfaceRealizations = new HashMap();
            this.realizations = new HashMap();
            this.manifestations = new HashMap();
            this.typedElements = new HashMap();
            this.properties = new HashMap();
            this.allElements = new HashMap();
            this.constraints = new HashMap();
            this.aliases = new HashMap();
        }

        public void putAll(ElementMaps elementMaps) {
            this.allClasses.putAll(elementMaps.allClasses);
            this.allReferableElements.putAll(elementMaps.allReferableElements);
            this.generals.putAll(elementMaps.generals);
            this.classifiers.putAll(elementMaps.classifiers);
            this.deployments.putAll(elementMaps.deployments);
            this.interfaceRealizations.putAll(elementMaps.interfaceRealizations);
            this.realizations.putAll(elementMaps.realizations);
            this.manifestations.putAll(elementMaps.manifestations);
            this.typedElements.putAll(elementMaps.typedElements);
            this.properties.putAll(elementMaps.properties);
            this.allElements.putAll(elementMaps.allElements);
            this.constraints.putAll(elementMaps.constraints);
            this.aliases.putAll(elementMaps.aliases);
        }
    }
}

