/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer;

import ch.e2e.builder.compiler.Properties;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtensionElement {
    public static Element createExtensionElement(Document document, Map<String, Object> extensionParameters) {
        Element extensionElement = document.createElementNS("http://schema.omg.org/spec/XMI/2.1", "xmi:Extension");
        extensionElement.setAttribute("extender", "E2E");
        extensionElement.appendChild(ExtensionElement.createExtensionImportedElement(document, extensionParameters));
        return extensionElement;
    }

    public static Element createExtensionElement(Document document, Element importedElement) {
        Element extensionElement = document.createElementNS("http://schema.omg.org/spec/XMI/2.1", "xmi:Extension");
        extensionElement.setAttribute("extender", "E2E");
        extensionElement.appendChild(importedElement);
        return extensionElement;
    }

    public static Element createExtensionImportedElement(Document document, Map<String, Object> extensionParameters) {
        Element importedElement = document.createElement("imported");
        Element compiler = document.createElement("Compiler");
        String version = new Properties().getProperty("version");
        compiler.setAttribute("version", version == null ? "" : version);
        importedElement.appendChild(compiler);
        for (String key : extensionParameters.keySet()) {
            importedElement.setAttribute(key, extensionParameters.get(key).toString());
        }
        return importedElement;
    }

    public static Element getExtensionImportedElement(File file) {
        try {
            if (file.exists() && file.length() > 0L) {
                Document document = DomUtilities.parse((File)file, (boolean)false, (boolean)false, (boolean)false);
                return (Element)DomUtilities.evaluate((Node)document.getDocumentElement(), (String)"/xmi:XMI/xmi:Extension[@extender='E2E']/imported", (QName)XPathConstants.NODE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

