/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.DescriptorElement;
import ch.e2e.builder.compiler.document.UmlDocument;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Service
extends DescriptorElement {
    public static final String ST_JAVA_VIRTUAL_MACHINE = "JavaVirtualMachine";
    private CompilableObject configuration;
    private UmlDocument umlDocument;
    private String name;
    private String shortName;
    private boolean javaService;
    private ArrayList<String> jarfiles;
    private ArrayList<String> jarfilesToDeploy;
    private ArrayList<String> resources;
    private ArrayList<String> xarfiles;
    private ArrayList<String> xarfilesToDeploy;

    public Service(Element serviceElement, CompilableObject configuration, UmlDocument descriptorDocument) {
        super(serviceElement);
        this.configuration = configuration;
        this.name = serviceElement.getAttribute("label");
        this.shortName = serviceElement.getAttribute("name");
        if (this.shortName == null || this.shortName.length() == 0) {
            this.shortName = this.name;
        } else {
            this.findUmlDocument(descriptorDocument);
        }
        this.checkJavaService(serviceElement);
    }

    public CompilableObject getConfiguration() {
        return this.configuration;
    }

    @Override
    public void clear() {
        this.configuration = null;
        this.umlDocument = null;
        super.clear();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public UmlDocument getUmlDocument() {
        return this.umlDocument;
    }

    public ArrayList<String> getJarfiles() {
        return this.jarfiles;
    }

    public ArrayList<String> getJarfilesToDeploy() {
        return this.jarfilesToDeploy;
    }

    public ArrayList<String> getXarfiles() {
        return this.xarfiles;
    }

    public ArrayList<String> getXarfilesToDeploy() {
        return this.xarfilesToDeploy;
    }

    public boolean isJavaService() {
        return this.javaService;
    }

    private void findUmlDocument(UmlDocument descriptorDocument) {
        if (this.shortName.charAt(0) == '/') {
            int index = this.shortName.lastIndexOf(47);
            this.umlDocument = descriptorDocument.getUmlDocumentFactory().getUmlDocumentByName(this.shortName.substring(0, index - 1));
        } else {
            this.umlDocument = descriptorDocument;
        }
    }

    private void checkJavaService(Element serviceElement) {
        String stereotype = serviceElement.getAttribute("stereotype");
        this.javaService = stereotype.equals(ST_JAVA_VIRTUAL_MACHINE);
        this.jarfiles = new ArrayList();
        this.jarfilesToDeploy = new ArrayList();
        this.readArchives("JarFile", this.jarfiles, this.jarfilesToDeploy, serviceElement);
        this.xarfiles = new ArrayList();
        this.xarfilesToDeploy = new ArrayList();
        this.readArchives("XSLTArchiveDeployment", this.xarfiles, this.xarfilesToDeploy, serviceElement);
        this.resources = new ArrayList();
    }

    private void readFilesToDeploy(String type, ArrayList<String> files, Element serviceElement) {
        NodeList nodes = serviceElement.getChildNodes();
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            if (!(nodes.item(i) instanceof Element) || !nodes.item(i).getNodeName().equals(type)) continue;
            Element resourceElement = (Element)nodes.item(i);
            String resource = resourceElement.getAttribute("filename");
            files.add(resource);
        }
    }

    private void readArchives(String type, ArrayList<String> archives, ArrayList<String> archivesToDeploy, Element serviceElement) {
        NodeList nodes = serviceElement.getElementsByTagName(type);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            if (!(nodes.item(i) instanceof Element)) continue;
            Element jarfileElement = (Element)nodes.item(i);
            String jarfile = jarfileElement.getAttribute("filename");
            archives.add(jarfile);
            if (!Boolean.valueOf(jarfileElement.getAttribute("deploy")).booleanValue()) continue;
            archivesToDeploy.add(jarfile);
        }
    }
}

