/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.PersistentStateClass;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.DeployErrorHandler;
import ch.e2e.builder.compiler.tools.UmlLocationElement;
import ch.e2e.dom.DomUtilities;
import ch.e2e.swing.TreeObject;
import ch.e2e.util.StringTools;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Deployment
implements TreeObject,
UmlLocationElement {
    private String name;
    private String umlLocation;
    private HashMap<String, ArrayList<String>> nodes;
    private CompilableObject compilableObject;
    private DeployErrorHandler deployErrorHandler;
    private int status;
    private int hashCode;
    private ArrayList<PersistentStateClass> persistentStates;
    private File targetFile;

    public Deployment(Element xmlElement, CompilableObject compilableObject) {
        this(xmlElement.getAttribute("name"), compilableObject);
        this.umlLocation = xmlElement.getAttribute("umlLocation");
        this.readNodes(xmlElement);
        this.hashCode = this.umlLocation.hashCode();
        this.status = 100;
    }

    protected Deployment(String name) {
        this.name = name;
    }

    protected Deployment(String name, CompilableObject compilableObject) {
        this.name = name;
        this.compilableObject = compilableObject;
        if (compilableObject != null) {
            File logfile = new File(new File(compilableObject.getUmlDocument().getDocumentWorkingFolder(), "errorlog"), name + ".deploy" + ".errors");
            this.deployErrorHandler = new DeployErrorHandler(logfile);
            this.readTraceInformation();
        }
    }

    public File getDeployFile() {
        return new File(this.compilableObject.getUmlDocument().getDocumentWorkingFolder(), this.getName() + this.compilableObject.getDescriptorFileExpansion() + ".deploy");
    }

    public File getTargetFile() {
        File result;
        if (this.targetFile == null) {
            UmlDocument umlDocument = this.compilableObject.getUmlDocument();
            File outputFolder = umlDocument.getSettings().getRepositoryFolder();
            if (!(outputFolder = new File(outputFolder, umlDocument.getDocumentName())).exists()) {
                outputFolder.mkdirs();
            }
            result = new File(outputFolder, this.name + this.compilableObject.getRepositoryFileExtension());
        } else {
            result = this.targetFile;
        }
        return result;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    public String getFullQualifiedName() {
        return this.getUmlDocument().getDocumentName() + '.' + this.getCompilableObject().getName() + '.' + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFilename() {
        return this.compilableObject == null ? this.name + ".descriptor" : this.name + this.compilableObject.getDescriptorFileExpansion() + ".descriptor";
    }

    public String getOldFilename() {
        return this.name + ".descriptor";
    }

    public String getNameXPath(String configuration) {
        return "Configurations/Configuration[@name='" + configuration + "']";
    }

    public String getBackwardNameXPath(String configuration) {
        return "Configurations/Configuration[@name='" + configuration + "']";
    }

    public boolean containsId(String id) {
        boolean result = false;
        Iterator<ArrayList<String>> idLists = this.nodes.values().iterator();
        while (!result && idLists.hasNext()) {
            result = idLists.next().contains(id);
        }
        return result;
    }

    public String getHost(String id) {
        String host = null;
        Iterator<String> nodesIterator = this.nodes.keySet().iterator();
        while (host == null && nodesIterator.hasNext()) {
            String nextHost = nodesIterator.next();
            if (!this.nodes.get(nextHost).contains(id)) continue;
            host = nextHost;
        }
        return host == null ? "NoHostInfo" : host;
    }

    public String getCompositeHost() {
        return this.getHost(this.getCompilableObject().getId());
    }

    public DeployErrorHandler getDeployErrorHandler() {
        return this.deployErrorHandler;
    }

    public void clearAllErrors(boolean deleteErrorLogs) {
        this.deployErrorHandler.clear(true, deleteErrorLogs);
    }

    public void setStatus(int status) {
        this.status = status == 6 ? 100 : (status == 5 ? 200 : 300);
    }

    public String toString() {
        return this.getName();
    }

    public int getType() {
        int errorType = this.deployErrorHandler.getErrorType() | this.compilableObject.getErrorType();
        int result = errorType == 1 ? 6002 : ((errorType & 8) != 0 ? 6005 : ((errorType & 4) != 0 ? (this.deployErrorHandler.getErrorAndWarningCount() > 0 ? 6006 : 6004) : ((errorType & 2) != 0 ? 6003 : 6001)));
        return result + this.status;
    }

    public Object getChild(int index) {
        return this.deployErrorHandler.getError(index);
    }

    public int getChildCount() {
        return this.deployErrorHandler.getErrorAndWarningCount();
    }

    public boolean isLeaf() {
        return this.deployErrorHandler.getErrorAndWarningCount() == 0;
    }

    public int getIndexOfChild(Object child) {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Deployment && this.hashCode == ((Deployment)obj).hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getUmlLocation() {
        return this.umlLocation;
    }

    protected void setUmlLocation(String umlLocation) {
        this.umlLocation = umlLocation;
    }

    @Override
    public UmlDocument getUmlDocument() {
        return this.compilableObject.getUmlDocument();
    }

    public CompilableObject getCompilableObject() {
        return this.compilableObject;
    }

    public String getPath() {
        return this.getCompilableObject().getUmlDocument().getDisplayName() + "." + this.getCompilableObject().getName() + "." + this.getName();
    }

    public boolean isCompiled() {
        File outputFolder = new File(System.getProperty("ch.e2e.builder.base.repository"));
        UmlDocument umlDocument = this.compilableObject.getUmlDocument();
        boolean result = false;
        if (umlDocument.getDocumentName() != null) {
            outputFolder = new File(outputFolder, umlDocument.getDocumentName());
            File repository = new File(outputFolder, this.getName() + this.compilableObject.getRepositoryFileExtension());
            result = repository.exists();
        }
        return result;
    }

    public ArrayList<PersistentStateClass> getPersistentStates() {
        return this.persistentStates;
    }

    public boolean hasPersistentStates() {
        return this.persistentStates.size() > 0;
    }

    public void readStatesClasses(Document traceDocument) throws XPathExpressionException {
        NodeList classes = (NodeList)DomUtilities.evaluate((Node)traceDocument, (String)"//PersistentStateClass", (QName)XPathConstants.NODESET);
        int length = classes.getLength();
        for (int i = 0; i < length; ++i) {
            Element node = (Element)classes.item(i);
            String name = DomUtilities.getTextValue((Element)node, (String)"Name", (String)"PersistantState");
            String type = DomUtilities.getTextValue((Element)node, (String)"Type", (String)"PersistantState");
            this.persistentStates.add(new PersistentStateClass(name, type));
        }
    }

    public String replaceHostInfo(String value, String id) {
        int index = value.indexOf("deployedHost:");
        if (index == -1) {
            String host = this.getHost(id);
            if (host != null) {
                value = StringTools.replaceProperty((String)value, (String)"deployedHost", (String)host);
            }
        } else {
            int startIndex = value.indexOf(58, index);
            int endIndex = value.indexOf(125, startIndex);
            String hostID = value.substring(startIndex + 1, endIndex);
            String host = this.getHost(hostID);
            value = value.substring(0, startIndex) + value.substring(endIndex);
            value = StringTools.replaceProperty((String)value, (String)"deployedHost", (String)host);
        }
        if (value.indexOf("deployedHost") != -1) {
            value = this.replaceHostInfo(value, id);
        }
        return value;
    }

    private void readTraceInformation() {
        this.persistentStates = new ArrayList();
        File traceFile = new File(this.compilableObject.getUmlDocument().getDocumentWorkingFolder(), this.name + ".asynchronous.trace");
        if (traceFile.exists()) {
            try {
                Document traceDocument = DomUtilities.parse((File)traceFile, (boolean)false, (boolean)false, (boolean)false);
                this.readStatesClasses(traceDocument);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void readNodes(Element xmlElement) {
        this.nodes = new HashMap();
        NodeList nodeList = xmlElement.getElementsByTagName("Node");
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element node = (Element)nodeList.item(i);
            this.addNode(node);
        }
    }

    private void addNode(Element node) {
        String nodeName = node.getAttribute("name");
        ArrayList<String> instanceIds = new ArrayList<String>();
        NodeList instances = node.getElementsByTagName("DeployedInstance");
        int length = instances.getLength();
        for (int i = 0; i < length; ++i) {
            Element instance = (Element)instances.item(i);
            String idref = instance.getAttribute("idref");
            instanceIds.add(idref);
        }
        this.nodes.put(nodeName, instanceIds);
    }
}

