/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.document.UmlDocument;
import org.w3c.dom.Element;

public class Composite
extends CompilableObject {
    private final String controlPortSettingName;
    private final String protocol;
    private final String folderName;
    private final String componentVersion;
    private boolean visible = false;

    public Composite(Element compositeElement, UmlDocument umlDocument) {
        super(compositeElement, umlDocument);
        this.controlPortSettingName = Composite.getControlPortSettingName(compositeElement);
        this.protocol = compositeElement.getAttribute("protocol");
        this.folderName = umlDocument.getUniqueId() + "." + this.getName();
        this.componentVersion = compositeElement.getAttribute("version");
    }

    private static String getControlPortSettingName(Element element) {
        String control = element.getAttribute("control");
        return control.startsWith("${") ? control.substring(2, control.length() - 1) : "";
    }

    public String getControlPortSettingName() {
        return this.controlPortSettingName;
    }

    public String getComponentVersion() {
        return this.componentVersion;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getFullName() {
        return this.folderName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getErrorLogExtension() {
        return ".composite.errors";
    }

    @Override
    public int getType() {
        int errorType = this.getErrorType();
        int deploymentErrorType = 0;
        for (Deployment deployment : this.getDeployments()) {
            deploymentErrorType |= deployment.getDeployErrorHandler().getErrorType();
        }
        int result = (deploymentErrorType & 4) != 0 ? 3006 : (errorType == 1 ? 3002 : ((errorType & 8) != 0 ? 3005 : ((errorType & 4) != 0 ? 3004 : ((errorType & 2) != 0 ? 3003 : ((deploymentErrorType & 4) != 0 ? 3006 : 3001)))));
        return result;
    }

    @Override
    public String getRepositoryFileExtension() {
        return ".rep";
    }

    @Override
    public String getDescriptorFileExpansion() {
        return ".composite";
    }

    @Override
    protected void addDeployment(Element xmlElement) {
        this.addDeployment(new Deployment(xmlElement, (CompilableObject)this));
    }
}

