/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.builder.base.error.BuilderError;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.descriptor.DescriptorElement;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.builder.compiler.descriptor.Service;
import ch.e2e.builder.compiler.descriptor.UIDeployment;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.ConfigurationErrorHandler;
import ch.e2e.dom.DomUtilities;
import ch.e2e.swing.TreeObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CompilableObject
extends DescriptorElement
implements TreeObject {
    private ConfigurationErrorHandler errorHandler;
    private UmlDocument umlDocument;
    private String name;
    private String umlLocation;
    private String classifierName;
    private int hashCode;
    private ArrayList<Service> services;
    private TreeMap<String, Deployment> deployments;
    private ArrayList<String> deploymentNames;
    private ArrayList<LibraryService> libraries;
    private ArrayList<UIDeployment> uiDeployments;
    private String[] jarfiles;
    private String[] jarfilesToDeploy;
    private String[] xarfilesToDeploy;
    private boolean containsJavaService;
    private String[] xsltScripts;
    private boolean inDebugMode = false;
    private String id;

    protected CompilableObject(Element xmlElement, UmlDocument umlDocument) {
        super(xmlElement);
        this.umlDocument = umlDocument;
        this.name = xmlElement.getAttribute("name");
        this.umlLocation = xmlElement.getAttribute("umlLocation");
        this.classifierName = xmlElement.getAttribute("classifierName");
        ArrayList<BuilderError> serviceErrors = this.readServices(xmlElement, umlDocument);
        this.errorHandler = new ConfigurationErrorHandler(this, serviceErrors);
        if (serviceErrors.size() > 0) {
            this.errorHandler.serialize(true);
        }
        this.hashCode = this.umlLocation.hashCode();
        this.deployments = new TreeMap();
        this.deploymentNames = new ArrayList();
        this.libraries = this.readLibraries(xmlElement);
        this.id = xmlElement.getAttribute("id");
        this.readUIDeployments(xmlElement);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getUmlLocation() {
        return this.umlLocation;
    }

    @Override
    public UmlDocument getUmlDocument() {
        return this.umlDocument;
    }

    public String getErrorLogExtension() {
        return ".errors";
    }

    public int getType() {
        return 0;
    }

    public boolean isLeaf() {
        return this.errorHandler.getErrorAndWarningCount() == 0 && this.deployments.size() == 0;
    }

    public Object getChild(int index) {
        Object result = null;
        if (index > -1 && this.deployments.size() > 0) {
            if (index < this.deployments.size()) {
                result = this.deployments.get(this.deploymentNames.get(index));
            } else if ((index -= this.deployments.size()) < this.errorHandler.getErrorAndWarningCount()) {
                result = this.errorHandler.getError(index);
            }
        }
        return result;
    }

    public int getChildCount() {
        return this.errorHandler.getErrorAndWarningCount() + this.deployments.size();
    }

    public int getIndexOfChild(Object child) {
        return 0;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof CompilableObject && this.hashCode == ((CompilableObject)obj).hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean canBuild() {
        return this.getUmlDocument().getEXMIErrorHandler().getErrorCount() == 0 && this.getErrorHandler().isDefinitionCorrect() && this.deployments != null && this.deployments.size() > 0;
    }

    public ConfigurationErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public String getName() {
        return this.name;
    }

    public String getClassifierName() {
        return this.classifierName;
    }

    public void clearAllErrors(boolean deleteErrorLogs) {
        this.errorHandler.clear(true, deleteErrorLogs);
        this.umlDocument.getErrorHandler().clear();
        for (Deployment deployment : this.deployments.values()) {
            deployment.clearAllErrors(deleteErrorLogs);
        }
    }

    public void addDeployment(Deployment deployment) {
        this.deployments.put(deployment.getName(), deployment);
        this.deploymentNames.add(deployment.getName());
    }

    public Collection<Deployment> getDeployments() {
        return this.deployments.values();
    }

    public Deployment getDeployment(String name) {
        return this.deployments.get(name);
    }

    public ArrayList<LibraryService> getLibraries() {
        return this.libraries;
    }

    public String[] getJarfiles() {
        return this.jarfiles;
    }

    public String[] getJarfilesToDeploy() {
        return this.jarfilesToDeploy;
    }

    public String[] getXSLTScripts() {
        return this.xsltScripts;
    }

    public String[] getXarfilesToDeploy() {
        return this.xarfilesToDeploy;
    }

    public boolean containsJavaService() {
        return this.containsJavaService;
    }

    public int getErrorType() {
        int error = 0;
        if (this.errorHandler != null) {
            error = Math.max(error, this.errorHandler.getErrorType());
        }
        if (error > 0) {
            error = Math.max(error, this.umlDocument.getErrorType());
        }
        return error;
    }

    public void clear(boolean deleteErrorLogs) {
        this.deployments.clear();
        this.deploymentNames.clear();
        for (Service service : this.services) {
            service.clear();
        }
        this.services.clear();
        this.clearAllErrors(deleteErrorLogs);
        super.clear();
    }

    public boolean isInDebugMode() {
        return this.inDebugMode;
    }

    public void setInDebugMode(boolean b) {
        this.inDebugMode = b;
    }

    public ArrayList<UIDeployment> getUiDeployments() {
        return this.uiDeployments;
    }

    protected abstract void addDeployment(Element var1);

    public abstract String getRepositoryFileExtension();

    public abstract String getDescriptorFileExpansion();

    protected ArrayList<BuilderError> readServices(Element compositeElement, UmlDocument umlDocument) {
        this.services = new ArrayList();
        ArrayList<BuilderError> errors = new ArrayList<BuilderError>();
        NodeList serviceList = compositeElement.getElementsByTagName("Service");
        if (serviceList != null) {
            int length = serviceList.getLength();
            for (int i = 0; i < length; ++i) {
                boolean createService;
                Element serviceElement = (Element)serviceList.item(i);
                boolean bl = createService = !serviceElement.hasAttribute("shadow") || Boolean.valueOf(serviceElement.getAttribute("shadow")) == false;
                if (!createService) continue;
                Service service = new Service(serviceElement, this, umlDocument);
                this.services.add(service);
            }
            this.readJavaArchives();
            this.readResources(compositeElement, "//JavaVirtualMachine/Resources/Resource");
            this.readResources(compositeElement, "Resources/Resource");
            this.readResources(compositeElement, "//Service[@stereotype='XSLTProcessor']/Resource");
        }
        return errors;
    }

    private ArrayList<LibraryService> readLibraries(Element xmlElement) {
        ArrayList<LibraryService> libraries = new ArrayList<LibraryService>();
        try {
            String xpath = "//" + xmlElement.getNodeName() + "[@name='" + this.name + "']//E2ELibraryProxyDeployment";
            NodeList libraryList = (NodeList)DomUtilities.evaluate((Node)xmlElement, (String)xpath, (NamespaceContext)null, (QName)XPathConstants.NODESET);
            int length = libraryList.getLength();
            for (int i = 0; i < length; ++i) {
                Element libraryElement = (Element)libraryList.item(i);
                libraries.add(new LibraryService(libraryElement.getAttribute("artifactName"), libraryElement.getAttribute("name"), libraryElement.getAttribute("path"), libraryElement.getAttribute("umlLocation"), this.getUmlDocument().getSettings().getLibraryFolder()));
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        return libraries;
    }

    private void readJavaArchives() {
        ArrayList<String> jarfileList = new ArrayList<String>();
        ArrayList<String> jarfilesToDeployList = new ArrayList<String>();
        ArrayList<String> xarfilesToDeployList = new ArrayList<String>();
        for (Service service : this.services) {
            this.containsJavaService |= service.isJavaService();
            this.addToList(jarfileList, service.getJarfiles());
            this.addToList(jarfilesToDeployList, service.getJarfilesToDeploy());
            this.addToList(xarfilesToDeployList, service.getXarfilesToDeploy());
        }
        this.jarfiles = new String[jarfileList.size()];
        jarfileList.toArray(this.jarfiles);
        this.jarfilesToDeploy = new String[jarfilesToDeployList.size()];
        jarfilesToDeployList.toArray(this.jarfilesToDeploy);
        this.xarfilesToDeploy = new String[xarfilesToDeployList.size()];
        xarfilesToDeployList.toArray(this.xarfilesToDeploy);
        this.xsltScripts = new String[0];
    }

    private void addToList(ArrayList<String> resourceList, ArrayList<String> listToAdd) {
        for (String s : listToAdd) {
            if (resourceList.contains(s)) continue;
            resourceList.add(s);
        }
    }

    private void readUIDeployments(Element xmlElement) {
        this.uiDeployments = new ArrayList();
        NodeList nodeList = xmlElement.getElementsByTagName("UIDeployment");
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            UIDeployment ui = new UIDeployment((Element)nodeList.item(i));
            this.uiDeployments.add(ui);
        }
    }
}

