/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.descriptor;

import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.BPMNValidationErrorHandler;
import ch.e2e.builder.compiler.tools.UmlLocationElement;
import ch.e2e.swing.TreeObject;
import org.w3c.dom.Element;

public class BPMNDiagram
implements UmlLocationElement,
TreeObject {
    private String name;
    private String id;
    private String umlLocation;
    private UmlDocument umlDocument;
    private BPMNValidationErrorHandler errorHandler;

    public BPMNDiagram(Element xmlElement, UmlDocument umlDocument) {
        this.umlDocument = umlDocument;
        this.id = xmlElement.getAttribute("id");
        this.name = xmlElement.getAttribute("name");
        this.umlLocation = xmlElement.getAttribute("umlLocation");
        this.errorHandler = new BPMNValidationErrorHandler(this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getUmlLocation() {
        return this.umlLocation;
    }

    @Override
    public UmlDocument getUmlDocument() {
        return this.umlDocument;
    }

    public int getType() {
        int errorType = this.errorHandler.getErrorType();
        int result = errorType == 1 ? 5002 : ((errorType & 8) != 0 ? 5005 : ((errorType & 4) != 0 ? 5004 : ((errorType & 2) != 0 ? 5003 : 5001)));
        return result;
    }

    public Object getChild(int index) {
        Object result = null;
        if (index > -1) {
            result = this.errorHandler.getError(index);
        }
        return result;
    }

    public int getChildCount() {
        return this.errorHandler.getErrorAndWarningCount();
    }

    public boolean isLeaf() {
        return this.errorHandler.getErrorAndWarningCount() == 0;
    }

    public int getIndexOfChild(Object child) {
        return 0;
    }
}

