/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.substitutions;

import ch.e2e.builder.compiler.build.types.substitutions.DefaultMergeStrategy;
import ch.e2e.builder.compiler.build.types.substitutions.Enumerator;
import ch.e2e.builder.compiler.build.types.substitutions.JavaClasspathVariable;
import ch.e2e.builder.compiler.build.types.substitutions.JavaMemoryVariable;
import ch.e2e.builder.compiler.build.types.substitutions.JavaOptionVariable;
import ch.e2e.builder.compiler.build.types.substitutions.JavaParallelOperationsVariable;
import ch.e2e.builder.compiler.build.types.substitutions.JavaVariable;
import ch.e2e.builder.compiler.build.types.substitutions.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JavaOptionMergeStrategy
extends DefaultMergeStrategy {
    private final String VM_CLASSPATH_VARIABLE = "ALIAS_VirtualMachine_ClassPath";
    private final String VM_PARALLEL_OP_VARIABLE = "ALIAS_VirtualMachine_ParallelOperations";
    private final String VM_OPTION_VARIABLE = "ALIAS_VirtualMachine_Options_Option";
    private final String VM_CLASSPATH_FRIENDLY = "AL_JVM_CLASSPATH";
    private final String VM_PARALLEL_OP_FRIENDLY = "AL_JVM_PARALLELOPERATIONS";
    private final String VM_OPTION_FRIENDLY = "AL_JVM_OPT";
    private String vmHeapSizeVariable;
    private String vmInitialMemoryVariable;
    private String vmDebugVariable;
    private List<String> existingOptions = new ArrayList<String>();

    @Override
    protected Variable getVariable(Map<String, Variable> variables, String varName, String varFriendlyId, String varLabel, String varDefault, String varType, ArrayList<Enumerator> enumerators, boolean isForwardDeclaration) {
        Variable variable = null;
        if (varName.contains("VirtualMachine_ClassPath")) {
            variable = variables.get("ALIAS_VirtualMachine_ClassPath");
        } else if (varName.contains("VirtualMachine_ParallelOperations")) {
            variable = variables.get("ALIAS_VirtualMachine_ParallelOperations");
        } else if (varDefault.startsWith("-Xmx")) {
            variable = variables.get(this.vmHeapSizeVariable);
        } else if (varDefault.startsWith("-Xms")) {
            variable = variables.get(this.vmInitialMemoryVariable);
        } else if (varDefault.startsWith("-agentlib") || varDefault.startsWith("-Xrunjdwp")) {
            variable = variables.get(this.vmDebugVariable);
        }
        if (variable == null) {
            variable = this.createVariable(varName, varFriendlyId, varLabel, varDefault, varType);
            if (variable != null) {
                variables.put(variable.getName(), variable);
            }
        } else if (variable instanceof JavaVariable) {
            ((JavaVariable)((Object)variable)).mergeDefaultValue(varDefault);
        }
        return variable;
    }

    private Variable createVariable(String varName, String varFriendlyId, String varLabel, String varDefault, String varType) {
        Variable variable = null;
        if (!this.ignoreOption(varDefault)) {
            if (varName.contains("VirtualMachine_ClassPath")) {
                variable = new JavaClasspathVariable("ALIAS_VirtualMachine_ClassPath", "AL_JVM_CLASSPATH", varLabel, varDefault, varType);
            } else if (varName.contains("VirtualMachine_ParallelOperations")) {
                variable = new JavaParallelOperationsVariable("ALIAS_VirtualMachine_ParallelOperations", "AL_JVM_PARALLELOPERATIONS", varLabel, varDefault, varType);
            } else if (!varName.contains("VirtualMachine_Options")) {
                variable = new JavaOptionVariable(varName, varFriendlyId, varLabel, varDefault, varType);
            } else if (!this.existingOptions.contains(varDefault)) {
                this.existingOptions.add(varDefault);
                String num = String.valueOf(this.existingOptions.size());
                varName = "ALIAS_VirtualMachine_Options_Option" + num;
                varFriendlyId = "AL_JVM_OPT" + num;
                if (varDefault.startsWith("-Xmx")) {
                    variable = new JavaMemoryVariable(varName, varFriendlyId, varLabel, varDefault, varType);
                    this.vmHeapSizeVariable = varName;
                } else if (varDefault.startsWith("-Xms")) {
                    variable = new JavaMemoryVariable(varName, varFriendlyId, varLabel, varDefault, varType);
                    this.vmInitialMemoryVariable = varName;
                } else {
                    variable = new JavaOptionVariable(varName, varFriendlyId, varLabel, varDefault, varType);
                    if (varDefault.startsWith("-agentlib") || varDefault.startsWith("-Xrunjdwp")) {
                        this.vmDebugVariable = varName;
                    }
                }
            }
        }
        return variable;
    }

    private boolean ignoreOption(String value) {
        return value.isEmpty() || value.startsWith("-Xss") || value.startsWith("-Xbootclasspath:") || value.startsWith("-Xbootclasspath/a:") || value.startsWith("-Xbootclasspath/p:");
    }
}

