/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.logger;

import ch.e2e.builder.compiler.build.types.logger.Level;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.dom.DomUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Filter
extends RichElement {
    public static final String ELEMENT_NAME = "filter";
    private Map<String, Level> levels = new TreeMap<String, Level>();
    private List<String> domains = new ArrayList<String>(){
        {
            this.add("*");
        }
    };

    public Filter() {
    }

    public Filter(Element tabfileElement) {
        super(tabfileElement);
        Iterator it = DomUtilities.elementIterator((NodeList)tabfileElement.getElementsByTagName("level"));
        while (it.hasNext()) {
            Level incoming = new Level((Element)it.next());
            this.levels.putIfAbsent(incoming.getAttributeValue("value"), incoming);
        }
    }

    public void merge(Filter other) {
        this.levels.putAll(other.levels);
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected void prepareChildren() {
        this.appendChildren(this.levels.values());
    }

    public JsonObjectBuilder buildJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Level l : this.levels.values()) {
            builder.add("level", Json.createArrayBuilder().add(l.getAttributeValue("value")));
        }
        builder.add("domains", Json.createArrayBuilder(this.domains));
        return builder;
    }

    public boolean hasLevel() {
        return !this.levels.isEmpty();
    }

    public String getLevel() {
        return this.levels.values().iterator().next().getAttributeValue("value");
    }
}

