/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.rest.descriptor;

import ch.e2e.builder.compiler.build.types.addons.rest.descriptor.Parameters;
import ch.e2e.builder.compiler.build.types.addons.rest.descriptor.Responses;
import ch.e2e.builder.compiler.build.types.addons.rest.descriptor.Tags;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.builder.compiler.build.types.tabfile.TextElement;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;

public abstract class Verb
extends RichElement {
    private Tags tags;
    private TextElement summary;
    private TextElement description;
    private Parameters parameters;
    private Responses responses;
    private Set<TextElement> accepts = new LinkedHashSet<TextElement>();

    public Verb(Element tabfileElement) {
        super(tabfileElement);
        this.tags = this.createFrom(tabfileElement, "tags", Tags.class);
        this.summary = this.createTextElementIfExist(tabfileElement, "summary");
        this.description = this.createTextElementIfExist(tabfileElement, "description");
        this.parameters = this.createFrom(tabfileElement, "parameters", Parameters.class);
        this.responses = this.createFrom(tabfileElement, "responses", Responses.class);
        Iterator<Element> acceptsIterator = Verb.getElementIteratorByXPath(tabfileElement, "accepts");
        while (acceptsIterator.hasNext()) {
            this.accepts.add(new TextElement(acceptsIterator.next()));
        }
    }

    @Override
    protected void prepareChildren() {
        this.appendChildren(this.accepts);
        this.appendChildren(this.tags, this.summary, this.description);
        if (this.parameters != null && this.parameters.hasEntries()) {
            this.appendChildren(this.parameters);
        }
        this.appendChildren(this.responses);
    }
}

