/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.rest.descriptor;

import ch.e2e.builder.compiler.build.types.addons.rest.descriptor.Definitions;
import ch.e2e.builder.compiler.build.types.addons.rest.descriptor.Path;
import ch.e2e.builder.compiler.build.types.addons.rest.descriptor.Security;
import ch.e2e.builder.compiler.build.types.addons.rest.descriptor.Tags;
import ch.e2e.builder.compiler.build.types.tabfile.Attribute;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import ch.e2e.builder.compiler.build.types.tabfile.TextElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class Port
extends RichElement {
    public static final String ELEMENT_NAME = "port";
    private boolean awaitingDefinition = false;
    public static final List<String> attributeNames = new ArrayList<String>(){
        {
            this.add("apiVersion");
            this.add("name");
            this.add("basePath");
            this.add("isGenerated");
        }
    };
    private TextElement description;
    private Set<TextElement> accepts = new LinkedHashSet<TextElement>();
    private Set<TextElement> produces = new LinkedHashSet<TextElement>();
    private Security security;
    private Tags tags;
    private Map<String, Path> paths = new LinkedHashMap<String, Path>();
    private Definitions definitions;

    public Port(Element tabfileElement) {
        super(tabfileElement);
        this.awaitingDefinition = Boolean.parseBoolean(tabfileElement.getAttribute("awaitingDefinition"));
        this.description = this.createTextElementIfExist(tabfileElement, "description");
        Iterator<Element> acceptsIterator = Port.getElementIteratorByXPath(tabfileElement, "accepts");
        while (acceptsIterator.hasNext()) {
            this.addAccepts(acceptsIterator.next());
        }
        Iterator<Element> producesIterator = Port.getElementIteratorByXPath(tabfileElement, "produces");
        while (producesIterator.hasNext()) {
            this.addProduces(producesIterator.next());
        }
        this.security = this.createFrom(tabfileElement, "security", Security.class);
        this.tags = this.createFrom(tabfileElement, "tags", Tags.class);
        Iterator<Element> pathsIterator = Port.getElementIteratorByXPath(tabfileElement, "path");
        while (pathsIterator.hasNext()) {
            this.addPath(pathsIterator.next());
        }
        this.definitions = this.createFrom(tabfileElement, "definitions", Definitions.class);
    }

    private void addAccepts(Element tabfileElement) {
        this.accepts.add(new TextElement(tabfileElement));
    }

    private void addProduces(Element tabfileElement) {
        this.produces.add(new TextElement(tabfileElement));
    }

    private void addPath(Element tabfileElement) {
        this.addPath(new Path(tabfileElement));
    }

    private void addPath(Path path) {
        Path oldPath = this.paths.get(path.getPath());
        if (oldPath == null) {
            this.paths.put(path.getPath(), path);
        } else {
            oldPath.mergeIn(path);
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean isAwaitingDefinition() {
        return this.awaitingDefinition;
    }

    public boolean isGenerated() {
        return Boolean.parseBoolean(this.getAttributeValue("isGenerated"));
    }

    public void mergeIn(Port that) {
        for (Attribute attribute : that.getAttributes().values()) {
            this.addAttribute(attribute);
        }
        this.awaitingDefinition = that.awaitingDefinition;
        this.description = that.description;
        if (!this.isGenerated() || !that.isGenerated()) {
            this.accepts = that.accepts;
            this.produces = that.produces;
            this.tags = that.tags;
            this.paths = that.paths;
            this.definitions = that.definitions;
        } else {
            this.accepts.addAll(that.accepts);
            this.produces.addAll(that.produces);
            if (this.tags != null) {
                if (that.tags != null) {
                    this.tags.addAll(that.tags.getTags());
                }
            } else {
                this.tags = that.tags;
            }
            if (this.definitions != null) {
                if (that.definitions != null) {
                    this.definitions.addAll(that.definitions.getDefinitions());
                }
            } else {
                this.definitions = that.definitions;
            }
            if (this.security != null) {
                if (that.security != null) {
                    this.security.addAll(that.security.getAuths());
                }
            } else {
                this.security = that.security;
            }
            for (Path path : that.paths.values()) {
                this.addPath(path);
            }
        }
    }

    @Override
    protected void prepareChildren() {
        this.appendChild(this.description);
        this.appendChildren(this.accepts);
        this.appendChildren(this.produces);
        this.appendChildren(this.security, this.tags);
        this.appendChildren(this.paths.values());
        this.appendChild(this.definitions);
    }

    @Override
    public List<String> getAttributeNames() {
        return attributeNames;
    }
}

