/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons.rest;

import ch.e2e.builder.compiler.build.types.addons.rest.TopLevelResource;
import ch.e2e.builder.compiler.build.types.tabfile.RichElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class Service
extends RichElement {
    public static final String ELEMENT_NAME = "Service";
    public static final List<String> attributeNames = new ArrayList<String>(){
        {
            this.add("name");
        }
    };
    private Map<String, TopLevelResource> resources = new LinkedHashMap<String, TopLevelResource>();

    public Service(Element tabfileElement) {
        super(tabfileElement);
        Iterator<Element> resourceIterator = Service.getElementIteratorByXPath(tabfileElement, "Resource");
        while (resourceIterator.hasNext()) {
            this.addResource(resourceIterator.next());
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    public void addResource(Element tabfileElement) {
        TopLevelResource resource = new TopLevelResource(tabfileElement);
        this.resources.put(resource.getPortClass(), resource);
    }

    @Override
    public List<String> getAttributeNames() {
        return attributeNames;
    }

    @Override
    protected void prepareChildren() {
        this.appendChildren(this.resources.values());
    }

    public String getServiceName() {
        return this.getAttributeValue("name");
    }

    public boolean importPorts(Map<String, TopLevelResource> definitions) {
        boolean allDone = true;
        for (Map.Entry<String, TopLevelResource> portEntry : this.resources.entrySet()) {
            TopLevelResource importedResource;
            if (portEntry.getValue().isAwaitingDefinition() && (importedResource = definitions.get(portEntry.getValue().getPortClass())) != null) {
                portEntry.setValue(importedResource);
            }
            allDone = allDone && portEntry.getValue().isAwaitingDefinition();
        }
        return allDone;
    }
}

