/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types.addons;

import ch.e2e.builder.base.io.UniqueIdExtender;
import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdapterTemplatesTabfile
extends XmlTabfile {
    public AdapterTemplatesTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream outputStream, boolean indent, boolean library) throws Exception {
        if (library) {
            super.serialize(outputStream, indent, library);
        } else {
            HashMap uniqueIds = new HashMap();
            File tempFile = File.createTempFile("adapter.templates", ".zip");
            tempFile.deleteOnExit();
            try {
                ZipOutputStream templatesOut = new ZipOutputStream(new FileOutputStream(tempFile));
                NodeList templates = (NodeList)DomUtilities.evaluate((Node)this.getTabfileDocument().getDocumentElement(), (String)"Template", (QName)XPathConstants.NODESET);
                IDElementExtender extender = new IDElementExtender();
                int length = templates.getLength();
                for (int i = 0; i < length; ++i) {
                    Element item = (Element)templates.item(i);
                    String id = item.getAttribute("id");
                    String fileID = UniqueIdService.createUniqueId((String)id, uniqueIds);
                    AdapterElement adapter = new AdapterElement(item.getAttribute("name"), item.getAttribute("package"), this.getAdapterType(item));
                    extender.idElements.put(fileID, adapter);
                    ZipEntry entry = new ZipEntry(fileID);
                    Document template = DomUtilities.newDocument();
                    Node newItem = item.cloneNode(true);
                    template.adoptNode(newItem);
                    template.appendChild(newItem);
                    templatesOut.putNextEntry(entry);
                    DomUtilities.serialize((OutputStream)templatesOut, (Document)template, (boolean)indent, (boolean)false);
                    templatesOut.closeEntry();
                }
                templatesOut.putNextEntry(new ZipEntry("adapter.template.ids"));
                UniqueIdService.saveIds(uniqueIds, (OutputStream)templatesOut, (UniqueIdExtender)extender, (boolean)false);
                templatesOut.closeEntry();
                templatesOut.close();
                FileUtilities.copy((InputStream)new FileInputStream(tempFile), (OutputStream)outputStream, (boolean)false);
            }
            finally {
                tempFile.delete();
            }
        }
    }

    private String getAdapterType(Element item) {
        Node firstElement = null;
        NodeList children = item.getChildNodes();
        int length = children.getLength();
        for (int i = 0; firstElement == null && i < length; ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            firstElement = (Element)children.item(i);
        }
        return firstElement == null ? "undefined" : firstElement.getNodeName();
    }

    @Override
    public String getExtension(boolean library) {
        return library ? super.getExtension(library) : ".zip";
    }

    @Override
    public String getFullName(boolean library) {
        return library ? super.getFullName(library) : "adapter.templates" + this.getExtension(library);
    }

    private class AdapterElement {
        private String name;
        private String packageName;
        private String type;

        private AdapterElement(String name, String packageName, String type) {
            this.name = name;
            this.packageName = packageName;
            this.type = type;
        }
    }

    private class IDElementExtender
    implements UniqueIdExtender {
        private HashMap<String, AdapterElement> idElements = new HashMap();

        private IDElementExtender() {
        }

        public void extendUniqueIdElement(Element uniqueIdElement) {
            AdapterElement adapterElement = this.idElements.get(uniqueIdElement.getAttribute("id"));
            if (adapterElement != null) {
                uniqueIdElement.setAttribute("name", adapterElement.name);
                uniqueIdElement.setAttribute("package", adapterElement.packageName);
                uniqueIdElement.setAttribute("type", adapterElement.type);
            }
        }

        public void readExtendedInfo(Element uniqueIdElment) {
        }
    }
}

