/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.BridgeXmiFile;
import ch.e2e.builder.compiler.build.types.E2EBuilderDataType;
import ch.e2e.builder.compiler.build.types.TabfileContainer;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.error.DocumentErrorHandler;
import ch.e2e.builder.compiler.xsltinterface.XSLTInput;
import java.io.File;

public class Xmi2Tab
implements E2EBuilderDataType {
    private BridgeXmiFile srcfile;
    private TabfileContainer tabfileTarget;

    public Xmi2Tab(UmlDocument umlDocument) {
        this.srcfile = new BridgeXmiFile(umlDocument);
        this.tabfileTarget = new TabfileContainer(umlDocument.getDocumentWorkingFolder(), umlDocument.getUniqueId() + ".tabfiles");
    }

    @Override
    public boolean isUpToDate(CompilableObject configuration) {
        boolean result = this.srcfile.isUpToDate(configuration);
        if (result && this.tabfileTarget != null) {
            result = this.tabfileTarget.exists();
            result &= this.tabfileTarget.lastModified() > this.srcfile.lastModified();
            result &= this.tabfileTarget.getTraceOption() == XSLTInput.getTraceState();
            result &= !(this.tabfileTarget.getStatemachineManual() ^ XSLTInput.executeStatemachineManual());
        }
        return result &= this.checkErrorLogfile();
    }

    public BridgeXmiFile getSrcfile() {
        return this.srcfile;
    }

    public TabfileContainer getTabfileTarget() {
        return this.tabfileTarget == null ? null : this.tabfileTarget;
    }

    private boolean checkErrorLogfile() {
        DocumentErrorHandler errorHandler = this.srcfile.getUmlDocument().getErrorHandler();
        File logfile = errorHandler.getLogfile();
        boolean result = logfile.exists();
        return result &= logfile.lastModified() > this.srcfile.lastModified();
    }
}

