/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.SubstitutionsTabfile;
import ch.e2e.builder.compiler.build.types.XPathReplacer;
import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.substitutions.TemplatedFile;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WsdlTabfile
extends XmlTabfile {
    public WsdlTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    @Override
    public void doMergePostProcess(SubstitutionsTabfile substitutions, boolean library) throws XPathExpressionException {
        TemplatedFile templatedFile = substitutions.getTemplates().get(this.getFilename());
        if (templatedFile != null) {
            templatedFile.setTarget(this.getFullName(library));
            templatedFile.setTemplate(this.getFullTemplateName(library));
        }
    }

    @Override
    public String getExtension(boolean library) {
        return ".wsdl";
    }

    @Override
    public String getFullName(boolean library) {
        return "wsdl/" + this.getKey(library) + this.getExtension(library);
    }

    @Override
    public String getFullTemplateName(boolean library) {
        return "templates/" + this.getFullName(library);
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        String tableConfigurationId = table.getAttribute("configurationID");
        String configurationID = configurationElement.getAttribute("classifierID");
        if (configurationID.equals(tableConfigurationId)) {
            Document document = DomUtilities.newDocument();
            this.setTabfileDocument(document);
            document.appendChild(document.importNode(table.getFirstChild(), true));
            XPathReplacer.replaceXPathExpressions(document, configurationElement, compilableObject, this.getErrorHandler());
        }
        return true;
    }
}

