/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.substitutions.Category;
import ch.e2e.builder.compiler.build.types.substitutions.Enumerator;
import ch.e2e.builder.compiler.build.types.substitutions.MergeStrategy;
import ch.e2e.builder.compiler.build.types.substitutions.Substitute;
import ch.e2e.builder.compiler.build.types.substitutions.TemplatedFile;
import ch.e2e.builder.compiler.build.types.substitutions.Variable;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.dom.DomUtilities;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SubstitutionsTabfile
extends XmlTabfile {
    private Map<String, TemplatedFile> templates = new LinkedHashMap<String, TemplatedFile>();
    private Map<String, Variable> variables = new LinkedHashMap<String, Variable>();
    private Map<String, Category> viewStructure = new LinkedHashMap<String, Category>();
    private Map<String, MergeStrategy> strategies = new LinkedHashMap<String, MergeStrategy>();
    private List<Substitute> substitutes = new ArrayList<Substitute>();

    public SubstitutionsTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
        this.setTabfileDocument(DomUtilities.newDocument((String)"Substitutions"));
    }

    private String getAttrDefault(Element element, String attrName, String defaultValue) {
        if (element.hasAttribute(attrName)) {
            return element.getAttribute(attrName);
        }
        return defaultValue;
    }

    public void removeVariableFromTemplate(String variableName, String template) {
        Variable variable = this.getVariables().get(variableName);
        if (variable != null) {
            TemplatedFile file = variable.removeFile(template);
            if (variable.getDependentFiles().isEmpty()) {
                this.getVariables().remove(variableName);
            }
            if (file != null) {
                if (file.getVariableCount() <= 0) {
                    this.templates.remove(file.getTemplate());
                }
                Iterator<Substitute> iterator = this.substitutes.iterator();
                while (iterator.hasNext()) {
                    Substitute substitute = iterator.next();
                    if (!substitute.getVariableName().equals(variableName) || !substitute.getTemplate().equals(file.getTemplate())) continue;
                    iterator.remove();
                }
            }
        }
    }

    public Map<String, TemplatedFile> getTemplates() {
        return this.templates;
    }

    public Map<String, Variable> getVariables() {
        return this.variables;
    }

    public Map<String, Category> getViewStructure() {
        return this.viewStructure;
    }

    @Override
    public void doMergePostProcess(SubstitutionsTabfile substitutions, boolean library) throws XPathExpressionException {
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        String configurationID;
        String tableConfigurationId = table.getAttribute("configurationID");
        if (tableConfigurationId != null && !"".equals(tableConfigurationId) && !tableConfigurationId.equals(configurationID = configurationElement.getAttribute("classifierID"))) {
            return true;
        }
        boolean library = libraryService != null;
        NodeList variableElements = table.getChildNodes();
        if (variableElements != null && variableElements.getLength() == 1 && table.getFirstChild() instanceof Text) {
            Node replacedNode = this.doReplace(table, configurationElement, compilableObject);
            variableElements = replacedNode.getChildNodes();
        }
        if (variableElements != null && variableElements.getLength() > 0) {
            String categoryName = this.getAttrDefault(table, "category", "Add-Ons");
            String sectionName = table.getAttribute("section");
            String targetName = table.getAttribute("target");
            String templateName = table.getAttribute("template");
            String mergeStrategy = this.getAttrDefault(table, "mergeStrategy", "default");
            Iterator it = DomUtilities.elementIterator((NodeList)variableElements);
            while (it.hasNext()) {
                Node currentNode = this.doReplace((Node)it.next(), configurationElement, compilableObject);
                if (currentNode == null) continue;
                if (currentNode instanceof Element) {
                    this.addSubstitute((Element)currentNode, categoryName, sectionName, targetName, templateName, mergeStrategy, library);
                    continue;
                }
                if (!(currentNode instanceof DocumentFragment)) continue;
                NodeList substitutions = currentNode.getChildNodes();
                Iterator it2 = DomUtilities.elementIterator((NodeList)substitutions);
                while (it2.hasNext()) {
                    this.addSubstitute((Element)it2.next(), categoryName, sectionName, targetName, templateName, mergeStrategy, library);
                }
            }
        }
        return true;
    }

    private MergeStrategy getStrategy(String mergeStrategyAttributeValue) {
        MergeStrategy strategy = null;
        try {
            String strategyClassName = this.getClass().getPackage().getName() + ".substitutions." + CompilerConstants.createClassName(mergeStrategyAttributeValue) + "MergeStrategy";
            strategy = this.strategies.get(strategyClassName);
            if (strategy == null) {
                Class<?> strategyClass = Class.forName(strategyClassName);
                strategy = (MergeStrategy)strategyClass.newInstance();
                this.strategies.put(strategyClassName, strategy);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strategy;
    }

    public void addSubstitute(Substitute substitute) {
        this.substitutes.add(substitute);
    }

    public void addSubstitute(Element element, String categoryName, String sectionName, String targetName, String templateName, String mergeStrategy, boolean library) {
        if (!this.isAllowed(element, targetName = this.getAttrDefault(element, "target", targetName), templateName = this.getAttrDefault(element, "template", templateName), library)) {
            return;
        }
        String varName = element.getAttribute("variableName");
        String varFriendlyId = element.getAttribute("friendlyId");
        String varLabel = element.getAttribute("label");
        String varDefault = element.getAttribute("default");
        String varType = element.getAttribute("type");
        NodeList enumerators = element.getElementsByTagName("enumerator");
        ArrayList<Enumerator> enumeratorList = new ArrayList<Enumerator>();
        Iterator it = DomUtilities.elementIterator((NodeList)enumerators);
        while (it.hasNext()) {
            Element enumeratorElement = (Element)it.next();
            enumeratorList.add(new Enumerator(enumeratorElement));
        }
        categoryName = this.getAttrDefault(element, "category", categoryName);
        sectionName = this.getAttrDefault(element, "section", sectionName);
        mergeStrategy = this.getAttrDefault(element, "mergeStrategy", mergeStrategy);
        MergeStrategy strategy = this.getStrategy(mergeStrategy);
        strategy.addSubstitute(this, element, categoryName, sectionName, targetName, templateName, varName, varFriendlyId, varLabel, varDefault, varType, enumeratorList);
    }

    private boolean isAllowed(Element element, String targetName, String templateName, boolean library) {
        boolean isForwardDeclaration = Boolean.parseBoolean(element.getAttribute("definedElsewhere"));
        return !library || isForwardDeclaration || !"AddOns/HTTP/service".equals(templateName) && !"AddOns/REST/service".equals(templateName) && !"AddOns/SOAP/Service/base".equals(templateName) && !"Main/CTRL/base".equals(templateName);
    }

    @Override
    public void serialize(OutputStream outputStream, boolean indent, boolean library) throws Exception {
        if (library) {
            Element rootElement = this.getTabfileDocument().getDocumentElement();
            rootElement.setAttribute("name", "substitutions");
            for (Substitute substitute : this.substitutes) {
                substitute.buildDom(rootElement, library);
            }
        } else {
            Document document = DomUtilities.newDocument((String)"Substitutions");
            Element rootElement = document.getDocumentElement();
            Element filesElement = document.createElement("Files");
            for (TemplatedFile file : this.templates.values()) {
                if ("".equals(file.getTemplate()) || "".equals(file.getTarget())) continue;
                Element fileElement = document.createElement("File");
                fileElement.setAttribute("template", file.getTemplate());
                fileElement.setAttribute("target", file.getTarget());
                filesElement.appendChild(fileElement);
            }
            rootElement.appendChild(filesElement);
            Element dependenciesElement = document.createElement("Dependencies");
            Element variablesElement = document.createElement("Variables");
            for (Variable v : this.variables.values()) {
                Element dependingElement = document.createElement("Depending");
                dependingElement.setAttribute("on", v.getName());
                for (TemplatedFile t : v.getDependentFiles().values()) {
                    if ("".equals(t.getTemplate())) continue;
                    Element dependentElement = document.createElement("Dependent");
                    dependentElement.setAttribute("template", t.getTemplate());
                    dependingElement.appendChild(dependentElement);
                }
                dependenciesElement.appendChild(dependingElement);
                Element variableElement = document.createElement("Variable");
                variableElement.setAttribute("name", v.getName());
                if (v.getFriendlyId() != null && !"".equals(v.getFriendlyId())) {
                    variableElement.setAttribute("friendlyId", v.getFriendlyId());
                }
                variableElement.setAttribute("type", v.getType());
                if (v.getEnumerators() != null) {
                    for (Enumerator enumerator : v.getEnumerators()) {
                        enumerator.buildDom(variableElement, library);
                    }
                }
                variableElement.setAttribute("default", v.getDefaultValue());
                variablesElement.appendChild(variableElement);
            }
            rootElement.appendChild(dependenciesElement);
            rootElement.appendChild(variablesElement);
            Element displayElement = document.createElement("Display");
            for (Category c : this.viewStructure.values()) {
                c.appendTo(displayElement);
            }
            rootElement.appendChild(displayElement);
            this.setTabfileDocument(document);
        }
        super.serialize(outputStream, indent, library);
    }
}

