/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.TabfileTools;
import ch.e2e.builder.compiler.build.types.Upload;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.document.UmlDocument;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.io.FileUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ModulesUpload
extends Upload {
    private CompilableObject configuration;

    public ModulesUpload(CompilableObject configuration) {
        super("input_modules");
        this.configuration = configuration;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(byteOut);
        ArrayList<UmlDocument> allUmlDocuments = this.configuration.getUmlDocument().getAllUmlDocuments();
        out.putNextEntry(new ZipEntry("tabfiles"));
        ArrayList<String> directories = new ArrayList<String>();
        for (UmlDocument umlDocument : allUmlDocuments) {
            File tabfile = new File(umlDocument.getDocumentWorkingFolder(), umlDocument.getUniqueId() + ".tabfiles");
            if (CompilerConstants.isInSrcPath(umlDocument.getOriginalFile())) {
                String relativePath = "tabfiles/" + FileUtilities.getRelativePath((File)umlDocument.getOriginalFile(), (File)CompilerConstants.getSourceFolder());
                TabfileTools.getInstance().addDirectory(relativePath, directories, out);
                out.putNextEntry(new ZipEntry(relativePath));
            } else {
                out.putNextEntry(new ZipEntry("tabfiles/" + umlDocument.getOriginalFile().getName()));
            }
            FileUtilities.copy((InputStream)new FileInputStream(tabfile), (OutputStream)out, (boolean)false);
            out.closeEntry();
        }
        out.flush();
        out.close();
        return new ByteArrayInputStream(byteOut.toByteArray());
    }

    @Override
    public String getFilename() {
        return this.configuration.getName();
    }
}

