/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.XmlTabfile;
import ch.e2e.builder.compiler.build.types.logger.Channel;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.LibraryService;
import ch.e2e.dom.DomUtilities;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoggerConfigTabfile
extends XmlTabfile {
    private Map<String, Channel> channels = new TreeMap<String, Channel>();

    public LoggerConfigTabfile(String rootElementName, String name, String filename) {
        super(rootElementName, name, filename);
    }

    @Override
    public boolean appendTable(Element table, Element configurationElement, CompilableObject compilableObject, LibraryService libraryService) {
        Element replaced = (Element)this.doReplace(table, configurationElement, compilableObject);
        Iterator channelIt = DomUtilities.elementIterator((NodeList)replaced.getElementsByTagName("channel"));
        while (channelIt.hasNext()) {
            this.addChannel((Element)channelIt.next(), configurationElement, configurationElement.getLocalName().equals("Library"));
        }
        return true;
    }

    private void addChannel(Element channelElement, Element configurationElement, boolean isLibrary) {
        Channel channel = new Channel(channelElement);
        String channelName = channel.getAttributeValue("name");
        boolean isAllowed = isLibrary;
        if (!isLibrary) {
            Node node = null;
            try {
                node = (Node)DomUtilities.evaluate((Node)configurationElement, (String)("LogChannels/channel[@name='" + channelName + "']"), (QName)XPathConstants.NODE);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
            boolean bl = isAllowed = node != null;
        }
        if (isAllowed) {
            Channel existing = this.channels.get(channelName);
            if (existing != null) {
                existing.merge(channel);
            } else {
                this.channels.put(channelName, channel);
            }
        }
    }

    @Override
    public void beforeSerialize(ZipOutputStream zipOut, String fileName, Boolean library) throws Exception {
        this.prepareDocument(library);
        super.beforeSerialize(zipOut, fileName, library);
    }

    public void prepareDocument(boolean library) {
        this.setTabfileDocument(null);
        Document tabfile = this.getDocument();
        tabfile.getDocumentElement().removeAttribute("xmlns:xmi");
        for (Channel c : this.channels.values()) {
            c.buildDom(tabfile.getDocumentElement(), library);
        }
    }

    @Override
    public String getExtension(boolean library) {
        return library ? super.getExtension(library) : ".json";
    }

    @Override
    public String getFullName(boolean library) {
        if (library) {
            return super.getFullName(library);
        }
        return this.getKey(library) + this.getExtension(library);
    }

    private JsonObjectBuilder buildErrorChannel() {
        return Json.createObjectBuilder().add("sinks", Json.createObjectBuilder().add("default", Json.createObjectBuilder().add("type", "daily_rotated_file").add("params", Json.createObjectBuilder().add("name_pattern", "logs/error_%Y-%m-%d.json")).add("formatter", Json.createObjectBuilder().add("type", "json")).add("filters", Json.createArrayBuilder().add(Json.createObjectBuilder().add("level", Json.createArrayBuilder().add("Info")).add("domains", Json.createArrayBuilder().add("*"))))).add("monitoring", Json.createObjectBuilder().add("type", "std_err").add("formatter", Json.createObjectBuilder().add("type", "json")).add("filters", Json.createArrayBuilder().add(Json.createObjectBuilder().add("level", Json.createArrayBuilder().add("Error")).add("domains", Json.createArrayBuilder().add("*"))))));
    }

    private JsonObjectBuilder buildAccessChannel() {
        return Json.createObjectBuilder().add("sinks", Json.createObjectBuilder().add("default", Json.createObjectBuilder().add("type", "daily_rotated_file").add("params", Json.createObjectBuilder().add("name_pattern", "logs/access_%Y-%m-%d.json")).add("formatter", Json.createObjectBuilder().add("type", "json")).add("filters", Json.createArrayBuilder().add(Json.createObjectBuilder().add("trx_level", Json.createArrayBuilder().add("NONE")).add("domains", Json.createArrayBuilder().add("*"))))));
    }

    @Override
    public void serialize(OutputStream outputStream, boolean indent, boolean library) throws Exception {
        if (library) {
            super.serialize(outputStream, indent, library);
        } else {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("error", this.buildErrorChannel());
            builder.add("access", this.buildAccessChannel());
            for (Channel c : this.channels.values()) {
                builder.add(c.getAttributeValue("name"), c.buildJson());
            }
            StringWriter writer = new StringWriter();
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
            properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            JsonWriterFactory writerFactory = Json.createWriterFactory(properties);
            try (JsonWriter jw = writerFactory.createWriter((Writer)writer);){
                jw.writeObject(Json.createObjectBuilder().add("channels", builder).build());
            }
            outputStream.write(writer.toString().getBytes(StandardCharsets.UTF_8));
        }
    }
}

