/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.AbstractBreakpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Breakpoint
extends AbstractBreakpoint
implements Comparable<Breakpoint> {
    public static final String ACTIVITY_FINAL_NODE = "activity final";
    public static final boolean ENABLED_DEFAULT = true;
    private static final String ELEMENT_NAME = "Breakpoint";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_PATH = "qualifiedName";
    private static final String ATTRIBUTE_DOCUMENT_ID = "documentId";
    private static final String ATTRIBUTE_ID = "id";
    private String id;
    private String path;
    private String name;
    private String xmiId;

    public Breakpoint(String name, String path, String documentId, String xmiId) {
        this(name, path, documentId, xmiId, true);
    }

    public Breakpoint(String name, String path, String documentId, String xmiId, boolean enabled) {
        super(documentId, enabled);
        this.path = path;
        this.xmiId = xmiId;
        this.setName(name);
    }

    public Breakpoint(Element element) {
        this(element.getAttribute(ATTRIBUTE_NAME), element.hasAttribute(ATTRIBUTE_PATH) ? element.getAttribute(ATTRIBUTE_PATH) : null, element.getAttribute(ATTRIBUTE_DOCUMENT_ID), null, element.hasAttribute("enabled") ? Boolean.valueOf(element.getAttribute("enabled")) : true);
        this.id = element.getAttribute(ATTRIBUTE_ID);
        int index = this.id.lastIndexOf(124);
        this.xmiId = index > -1 ? this.id.substring(index + 1) : null;
    }

    public String getId() {
        return this.id;
    }

    public String getXmiId() {
        return this.xmiId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        String n = ACTIVITY_FINAL_NODE.equals(name) ? "" : name.replaceAll("\\W", "_");
        this.id = n + "..." + this.getDocumentId() + "|" + this.getXmiId();
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public String getNameForList() {
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(this.getName());
        if (this.path != null) {
            sb.append("<span style=\"color:#BDBDBD\"> (").append(this.path).append(")</span>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public String getDescription() {
        return this.getId();
    }

    @Override
    public Element encode(Document document) {
        Element element = document.createElement(ELEMENT_NAME);
        element.setAttribute(ATTRIBUTE_NAME, this.name);
        if (this.path != null) {
            element.setAttribute(ATTRIBUTE_PATH, this.path);
        }
        element.setAttribute(ATTRIBUTE_DOCUMENT_ID, this.getDocumentId());
        element.setAttribute(ATTRIBUTE_ID, this.id);
        element.setAttribute("enabled", String.valueOf(this.isEnabled()));
        return element;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Breakpoint && this.id.equals(((Breakpoint)obj).id);
    }

    @Override
    public int compareTo(Breakpoint breakpoint) {
        return this.id.compareTo(breakpoint.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

