/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.source;

import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.tasks.source.JavaResourceSource;
import ch.e2e.builder.compiler.build.tasks.source.Logging;
import ch.e2e.builder.compiler.build.tasks.source.ProjectFileSource;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceFactory;
import ch.e2e.builder.compiler.build.tasks.source.TaskFactory;
import ch.e2e.builder.compiler.build.tasks.source.TaskSourceSetFactory;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class SourceManager {
    public static final Double DEFAULT_PRIORITY = 1.0;
    private final File projectFolder;
    private final File workFolder;
    private final List<CompileControl> controls = new ArrayList<CompileControl>();
    private final Map<String, Source> sourceMap = new HashMap<String, Source>();
    private final LinkedList<SourceFactory> sourceFactories;
    private final LinkedList<TaskFactory> taskFactories;
    private final Set<TaskSourceSetFactory> taskSourceSetFactories;
    private final Map<String, Object> customObjects = new HashMap<String, Object>();

    public SourceManager(File projectFolder, LinkedList<SourceFactory> sourceFactories, LinkedList<TaskFactory> taskFactories, Set<TaskSourceSetFactory> taskSourceSetFactories) {
        this.sourceFactories = sourceFactories;
        this.taskFactories = taskFactories;
        this.taskSourceSetFactories = taskSourceSetFactories;
        this.projectFolder = projectFolder;
        this.workFolder = new File(projectFolder, CompilerConstants.WORK_FOLDER);
    }

    public File getProjectFolder() {
        return this.projectFolder;
    }

    public File getWorkFolder() {
        return this.workFolder;
    }

    public Source getSource(String id) {
        if (id == null) {
            return null;
        }
        Source source = this.sourceMap.get(id);
        if (source != null) {
            return source;
        }
        if (id.startsWith(JavaResourceSource.resourceIdPrefix)) {
            if (JavaResourceSource.getResource(id) != null) {
                source = new JavaResourceSource(id);
                this.sourceMap.put(id, source);
                return source;
            }
            return null;
        }
        File file = new File(this.projectFolder, id);
        if (file.exists()) {
            try {
                SourceFactory sourceFactory = this.getSourceFactory(id);
                if (sourceFactory != null) {
                    source = sourceFactory.createSource(file, this);
                }
            }
            catch (Exception e) {
                source = new ProjectFileSource(file);
            }
            this.sourceMap.put(id, source);
            return source;
        }
        source = this.getTask(id);
        this.sourceMap.put(id, source);
        return source;
    }

    private Source getTask(String id) {
        CacheAbleTask task = null;
        TaskFactory taskFactory = this.getTaskFactory(id);
        if (taskFactory != null) {
            task = taskFactory.createTask(id, this);
        } else {
            Logging.logger.warning("No task factory found for '" + id + "'");
        }
        return task;
    }

    private SourceFactory getSourceFactory(String id) {
        for (SourceFactory sourceFactory : this.sourceFactories) {
            if (!sourceFactory.matchId(id).booleanValue()) continue;
            return sourceFactory;
        }
        return null;
    }

    private TaskFactory getTaskFactory(String id) {
        for (TaskFactory taskFactory : this.taskFactories) {
            if (!taskFactory.matchId(id).booleanValue()) continue;
            return taskFactory;
        }
        return null;
    }

    public Stream<TaskSourceSetFactory> getTaskSourceSetFactoryStream(String id) {
        return this.taskSourceSetFactories.stream().filter(taskSourceSetFactory -> taskSourceSetFactory.select(id));
    }

    public CompileControl[] getCompileControls() {
        return this.controls.toArray(new CompileControl[0]);
    }

    public SourceManager addCompileControl(CompileControl control) {
        Optional.ofNullable(control).ifPresent(this.controls::add);
        return this;
    }

    public String relativize(File file) {
        return this.getProjectFolder().toPath().relativize(file.toPath()).toString();
    }

    @Deprecated
    public void putCustomObject(String key, Object object) {
        this.customObjects.put(key, object);
    }

    @Deprecated
    public Object getCustomObject(String key) {
        return this.customObjects.get(key);
    }

    public Stream<Path> getSourceFilesStream() throws IOException {
        Path projectPath = this.getProjectFolder().toPath();
        String workFolder = this.getWorkFolder().toPath().toString();
        return Files.walk(projectPath, new FileVisitOption[0]).filter(path -> !path.toString().startsWith(workFolder));
    }

    public Stream<String> getSourceIdsStream() throws IOException {
        Path projectPath = this.getProjectFolder().toPath();
        return this.getSourceFilesStream().map(path -> projectPath.relativize((Path)path).toString().replace("\\", "/"));
    }
}

