/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.resources;

import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.model.ZipTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;

public class ResourcesZipTask
extends ZipTask {
    private static final String[] EXTENSIONS_TO_FILTER_OUT = new String[]{".hash", ".errors", ".sources", ".file.list"};

    public ResourcesZipTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    public static Boolean select(String id) {
        return id.endsWith("resources.zip");
    }

    @Override
    protected Path[] getInputFolderPaths() {
        return new Path[]{this.getDestinationFile().getParentFile().toPath()};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doFilter(Path path) {
        if (!super.doFilter(path)) return false;
        if (path.endsWith("resources.zip")) return false;
        if (!Stream.of(EXTENSIONS_TO_FILTER_OUT).noneMatch(path.getFileName().toString()::endsWith)) return false;
        return true;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        try {
            this.sourceManager.getSourceFilesStream().map(path -> path.getFileName().toString()).filter(filename -> filename.endsWith(".bpmn.json")).forEach(filename -> {
                if (filename.endsWith(".bpmn.json")) {
                    result.add(Files.resources_security__PROCESS_bpmn_authorizations_json(filename.replace(".bpmn.json", "")));
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

