/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.libraries.form;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.JsonDocument;
import ch.e2e.builder.compiler.document.json.library.LibraryForm;
import ch.e2e.builder.compiler.document.json.xuml.form.XumlForm;
import ch.e2e.builder.compiler.document.json.xuml.form.XumlFormElementChild;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

public class LibraryFormTask
extends CacheAbleTask
implements JsonDocumentSource {
    private LibraryForm jsonDocument;
    private XumlForm xumlForm;

    public static Boolean select(String id) {
        return !id.startsWith("libs/") && id.endsWith(".library.form.json");
    }

    public LibraryFormTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getSourceId());
        return result;
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        this.getXumlForm().getFormElements().stream().filter(xumlFormElement -> xumlFormElement instanceof XumlFormElementChild).forEach(xumlFormElement -> result.add(((XumlFormElementChild)xumlFormElement).getForm() + ".library.form.json"));
        return result;
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".library.form.json";
    }

    private String getSourceId() {
        return this.getDestinationFilePathWithoutExtension() + ".form.xml";
    }

    private XumlForm getXumlForm() {
        if (this.xumlForm == null) {
            JsonDocumentSource source = (JsonDocumentSource)this.getSourceManager().getSource(this.getSourceId());
            this.xumlForm = source.getJsonDocument(XumlForm.class);
        }
        return this.xumlForm;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            this.jsonDocument = new LibraryForm();
            this.jsonDocument.setName(this.getXumlForm().getName());
            this.jsonDocument.setComponent(this.getXumlForm().getName() + "FormComponent");
            this.jsonDocument.setClass_("urn:Data_Model.Forms." + this.getXumlForm().getName());
            HashSet formEvents = new HashSet();
            if (this.getXumlForm().getFormElements() != null) {
                this.getXumlForm().getFormElements().forEach(xumlFormElement -> {
                    if (xumlFormElement.getEvents() != null) {
                        xumlFormElement.getEvents().forEach(xumlFormEvent -> formEvents.add(xumlFormElement.getName() + "." + xumlFormEvent.getName()));
                    }
                    if (xumlFormElement instanceof XumlFormElementChild) {
                        JsonDocumentSource source = (JsonDocumentSource)this.getSourceManager().getSource(((XumlFormElementChild)xumlFormElement).getForm() + ".library.form.json");
                        source.getJsonDocument(LibraryForm.class).getFormEvents().forEach(formEvent -> formEvents.add(xumlFormElement.getName() + "." + formEvent));
                    }
                });
            }
            this.jsonDocument.setFormEvents(new ArrayList<String>(formEvents));
            HashMap jaxbProperties = new HashMap();
            JAXBContext jaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{LibraryForm.class}, jaxbProperties);
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            jaxbMarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            jaxbMarshaller.setProperty("eclipselink.json.include-root", (Object)false);
            this.getDestinationFile().getParentFile().mkdirs();
            this.getDestinationFile().createNewFile();
            jaxbMarshaller.marshal((Object)this.jsonDocument, this.getDestinationFile());
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public <T extends JsonDocument> T getJsonDocument(Class<T> type) {
        if (this.jsonDocument == null) {
            if (!this.isExecuted()) {
                this.execute();
            }
            if (this.isUpToDate()) {
                try {
                    HashMap jaxbProperties = new HashMap();
                    JAXBContext jaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{LibraryForm.class}, jaxbProperties);
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    jaxbUnmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
                    jaxbUnmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
                    this.jsonDocument = (LibraryForm)jaxbUnmarshaller.unmarshal((Source)new StreamSource(this.getDestinationFile()), LibraryForm.class).getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return (T)this.jsonDocument;
    }
}

