/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.form;

import ch.e2e.builder.compiler.build.tasks.model.model2xmi.Json2XmlTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlNamed;
import ch.e2e.builder.compiler.document.json.xuml.form.XumlForm;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class FormHelper {
    public static Set<File> getFormJsonFiles(SourceManager sourceManager) {
        HashSet<File> result = new HashSet<File>();
        File[] formFolderContent = new File(sourceManager.getProjectFolder(), "form").listFiles();
        if (formFolderContent != null) {
            Arrays.stream(formFolderContent).filter(file -> !file.isDirectory() && file.getPath().endsWith(".form.json")).forEach(result::add);
        }
        return result;
    }

    public static Set<String> getFormJsonDocumentSourceSet(SourceManager sourceManager) {
        return FormHelper.getFormJsonFiles(sourceManager).stream().map(sourceManager::relativize).map(file -> file.replace(System.getProperty("file.separator"), "/").replace(".json", ".xml")).collect(Collectors.toSet());
    }

    public static Set<XumlForm> getXumlForms(SourceManager sourceManager) {
        return FormHelper.getFormJsonDocumentSourceSet(sourceManager).stream().map(id -> ((Json2XmlTask)sourceManager.getSource((String)id)).getJsonDocument(XumlForm.class)).collect(Collectors.toSet());
    }

    public static Set<String> getLibraryForms(SourceManager sourceManager) {
        return FormHelper.getXumlForms(sourceManager).stream().filter(XumlForm::getLibraryExposed).map(XumlNamed::getName).collect(Collectors.toSet());
    }
}

