/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.dataModel;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibraryIdlMapTask;
import ch.e2e.builder.compiler.build.tasks.source.IDLSource;
import ch.e2e.builder.compiler.build.tasks.source.LibraryIdlMapSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.document.importer.IDLImportSource;
import ch.e2e.builder.compiler.document.json.xuml.XumlBehavior;
import ch.e2e.builder.compiler.document.json.xuml.XumlCallAction;
import ch.e2e.builder.compiler.document.json.xuml.XumlCallOperationAction;
import ch.e2e.builder.compiler.document.json.xuml.XumlPin;
import ch.e2e.builder.compiler.error.ModelError;
import ch.e2e.builder.compiler.uml.BridgeClass;
import ch.e2e.builder.compiler.uml.BridgeOperation;
import ch.e2e.builder.compiler.uml.BridgeParameter;
import ch.e2e.builder.compiler.uml.Direction;
import ch.e2e.builder.compiler.uml.TypedElement;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

public abstract class BehaviorWithReferenceTask
extends CacheAbleTask
implements XSLTTransformSource {
    public HashMap<String, IDLSource> idlSources;
    public DOMResult result;

    public BehaviorWithReferenceTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(LibraryIdlMapTask.LibraryIdlMapTask_ID);
        return result;
    }

    private LibraryIdlMapSource getLibraryIdlMapSource() {
        return (LibraryIdlMapSource)this.getSource(LibraryIdlMapTask.LibraryIdlMapTask_ID);
    }

    private HashMap<String, IDLSource> getLibrariesIDLSources() {
        HashMap<String, IDLSource> idlSourceHashMap = new HashMap<String, IDLSource>();
        this.getLibraryIdlMapSource().getLibraryIdlMap().getMap().forEach((key, value) -> idlSourceHashMap.put("libs/" + key + ".library.json", (IDLSource)this.getSource((String)value)));
        return idlSourceHashMap;
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getSourceId());
        result.addAll(this.getLibraryIdlMapSource().getLibraryIdlMap().getMap().values());
        return result;
    }

    public abstract String getSourceId();

    public UmlElement getType(String id) {
        if (id == null) {
            return null;
        }
        if (id.contains("#")) {
            String file = id.substring(0, id.indexOf("#"));
            String elementId = id.substring(id.indexOf("#") + 1);
            IDLSource idlSource = this.idlSources.get(file);
            if (idlSource != null) {
                return idlSource.getIDLImportSource().getElementMaps().allClasses.get(elementId);
            }
        } else {
            for (IDLSource idlSource : this.idlSources.values()) {
                UmlElement result = idlSource.getIDLImportSource().getElementMaps().allClasses.get(id);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public IDLSource getIdlSource(String id) {
        if (id.contains("#")) {
            String file = id.substring(0, id.indexOf("#"));
            return this.idlSources.get(file);
        }
        for (IDLSource idlSource : this.idlSources.values()) {
            UmlElement result = idlSource.getIDLImportSource().getElementMaps().allClasses.get(id);
            if (result == null) continue;
            return idlSource;
        }
        return null;
    }

    public String getIdlFileRef(String id) {
        if (id.contains("#")) {
            return id.substring(0, id.indexOf("#"));
        }
        for (Map.Entry<String, IDLSource> entry : this.idlSources.entrySet()) {
            UmlElement result = entry.getValue().getIDLImportSource().getElementMaps().allClasses.get(id);
            if (result == null) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean directionMatches(Direction bridgeDirection, String direction) {
        return bridgeDirection.toString().toLowerCase().equals(direction.toLowerCase()) || bridgeDirection == Direction.INOUT && (direction.equals("in") || direction.equals("out"));
    }

    public Boolean containsParameter(XumlPin parameter, BridgeOperation bridgeOperation, IDLSource idlSource) {
        if (parameter.getType() != null) {
            if (parameter.getDirection().equals("target")) {
                return !bridgeOperation.isStatic();
            }
            IDLImportSource idlImportSource = idlSource.getIDLImportSource();
            HashMap<Object, TypedElement> typedElements = idlImportSource.getElementMaps().typedElements;
            String type = parameter.getType().substring(parameter.getType().indexOf("#") + 1);
            for (UmlElement umlElementParameter : bridgeOperation.getParameters()) {
                BridgeParameter bridgeParameter;
                if (!(umlElementParameter instanceof BridgeParameter) || !(bridgeParameter = (BridgeParameter)umlElementParameter).getName().equals(parameter.getName()) || !this.directionMatches(bridgeParameter.getDirection(), parameter.getDirection())) continue;
                for (Map.Entry<Object, TypedElement> elementEntry : typedElements.entrySet()) {
                    String t;
                    if (elementEntry.getValue() != bridgeParameter) continue;
                    String pType = idlImportSource.getTypeFromOriginalObject(elementEntry.getKey());
                    if (type.equals(pType = pType.substring(pType.indexOf("#") + 1))) {
                        return true;
                    }
                    if (!pType.equals("http://www.e2e.ch/bridge/types/Array") || parameter.getMultiplicity().endsWith("1") || (t = idlImportSource.getArrayElementFromOriginalObject(elementEntry.getKey())) == null || !t.substring(t.indexOf("#") + 1).equals(type)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setCalledOperation(List<XumlCallAction> actions) {
        this.idlSources = this.getLibrariesIDLSources();
        if (actions != null) {
            AbstractErrorHandler errorHandler = this.getErrorHandler();
            block0: for (XumlCallAction action : actions) {
                HashMap<String, String> parameters;
                XumlCallOperationAction callOperation;
                UmlElement umlElementClass;
                if (!(action instanceof XumlCallOperationAction) || !((umlElementClass = this.getType((callOperation = (XumlCallOperationAction)action).getClass_())) instanceof BridgeClass)) continue;
                BridgeClass bridgeClass = (BridgeClass)umlElementClass;
                long overloads = bridgeClass.getOperations().stream().filter(operation -> operation.getName().equals(callOperation.getName())).count();
                boolean isOverloaded = overloads > 1L;
                boolean matchingInterfaceExists = false;
                if (overloads > 0L) {
                    block1: for (BridgeOperation bridgeOperation : bridgeClass.getOperations()) {
                        if (!bridgeOperation.getName().equals(callOperation.getName())) continue;
                        IDLSource idlSource = this.getIdlSource(callOperation.getClass_());
                        for (XumlPin xumlPin : callOperation.getPins()) {
                            if (this.containsParameter(xumlPin, bridgeOperation, idlSource).booleanValue()) continue;
                            if (idlSource == null || isOverloaded) continue block1;
                            HashMap<String, String> parameters2 = new HashMap<String, String>();
                            parameters2.put("parameter", xumlPin.getName());
                            parameters2.put("operation name", callOperation.getName());
                            errorHandler.error((AbstractBuilderError)new ModelError("ELIB0005", parameters2, callOperation.getId()));
                            continue block1;
                        }
                        for (UmlElement umlElement : bridgeOperation.getParameters()) {
                            boolean used = false;
                            for (XumlPin parameter : callOperation.getPins()) {
                                if (!parameter.getName().equals(umlElement.getName())) continue;
                                used = true;
                                break;
                            }
                            if (used) continue;
                            if (idlSource == null || isOverloaded) continue block1;
                            HashMap<String, String> parameters3 = new HashMap<String, String>();
                            parameters3.put("parameter", umlElement.getName());
                            parameters3.put("operation name", callOperation.getName());
                            errorHandler.error((AbstractBuilderError)new ModelError("ELIB0006", parameters3, callOperation.getId()));
                            continue block1;
                        }
                        if (idlSource == null) continue;
                        matchingInterfaceExists = true;
                        for (Map.Entry entry : idlSource.getIDLImportSource().getElementMaps().allReferableElements.entrySet()) {
                            if (entry.getValue() != bridgeOperation) continue;
                            callOperation.setCalledOperation(this.getIdlFileRef(callOperation.getClass_()) + "#" + (String)entry.getKey());
                            continue block0;
                        }
                    }
                    if (matchingInterfaceExists) continue;
                    parameters = new HashMap();
                    parameters.put("operation name", callOperation.getName());
                    errorHandler.error((AbstractBuilderError)new ModelError("ELIB0004", parameters, callOperation.getId()));
                    continue;
                }
                parameters = new HashMap<String, String>();
                parameters.put("operation name", callOperation.getName());
                errorHandler.error((AbstractBuilderError)new ModelError("ELIB0003", parameters, callOperation.getId()));
            }
        }
    }

    public <T extends XumlBehavior> Marshaller getMarshaller(Class<T> behaviorClass) throws Exception {
        HashMap jaxbProperties = new HashMap();
        JAXBContext jaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{behaviorClass}, jaxbProperties);
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return jaxbMarshaller;
    }
}

