/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibraryIdlMapTask;
import ch.e2e.builder.compiler.build.tasks.source.IDLSource;
import ch.e2e.builder.compiler.build.tasks.source.LibraryIdlMapSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.document.XmiTransformationModelHelper;
import ch.e2e.builder.compiler.models.Models;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.Module;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XmiTransformationModelResolveIdsTask
extends CacheAbleTask
implements XSLTTransformSource {
    private Map<String, Module> dependingModules;
    private Document result;

    public XmiTransformationModelResolveIdsTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".xmiTransformationModel.rId.xml";
    }

    protected Map<String, Module> getDependingModules() {
        return new HashMap<String, Module>();
    }

    private Map<String, Module> getCachedDependingModules() {
        if (this.dependingModules == null) {
            this.dependingModules = this.getDependingModules();
        }
        return this.dependingModules;
    }

    protected String getSourceId() {
        return this.getDestinationFilePathWithoutExtension() + ".xmiTransformationModel.xml";
    }

    private Element getSourceElement() {
        XSLTTransformSource source = (XSLTTransformSource)this.getSource(this.getSourceId());
        Node node = XSLTTransformSource.getNode(source.getXSLTTransformSource());
        return node instanceof Document ? ((Document)node).getDocumentElement() : (Element)node;
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(LibraryIdlMapTask.LibraryIdlMapTask_ID);
        return result;
    }

    private LibraryIdlMapSource getLibraryIdlMapSource() {
        return (LibraryIdlMapSource)this.getSource(LibraryIdlMapTask.LibraryIdlMapTask_ID);
    }

    private HashMap<String, IDLSource> getLibrariesIDLSources() {
        HashMap<String, IDLSource> idlSourceHashMap = new HashMap<String, IDLSource>();
        this.getLibraryIdlMapSource().getLibraryIdlMap().getMap().forEach((key, value) -> idlSourceHashMap.put((String)key, (IDLSource)this.getSourceManager().getSource((String)value)));
        return idlSourceHashMap;
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> sourceSet = new HashSet<String>();
        sourceSet.add(this.getSourceId());
        sourceSet.addAll(this.getCachedDependingModules().keySet());
        sourceSet.addAll(this.getLibraryIdlMapSource().getLibraryIdlMap().getMap().values());
        return sourceSet;
    }

    private ArrayList<String> getModelIds(Element model) throws XPathExpressionException {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xmi", "http://schema.omg.org/spec/XMI/2.1");
        List idNodes = DomUtilities.selectNodes((Node)model, (String)"//@xmi:id", namespaces);
        namespaces.clear();
        namespaces.put("xmi", "http://www.omg.org/spec/XMI/20131001");
        idNodes.addAll(DomUtilities.selectNodes((Node)model, (String)"//@xmi:id", namespaces));
        namespaces.clear();
        namespaces.put("xmi", "http://schema.omg.org/spec/XMI/20131001");
        idNodes.addAll(DomUtilities.selectNodes((Node)model, (String)"//@xmi:id", namespaces));
        ArrayList<String> ids = new ArrayList<String>();
        for (Node node : idNodes) {
            ids.add(((Attr)node).getValue());
        }
        return ids;
    }

    protected String getModuleName() {
        return this.getDestinationFileNameWithoutExtension() + ".xml";
    }

    protected String getModuleId() {
        return this.getModuleName() + "_" + this.getModuleName().hashCode();
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        HashMap<Module, ArrayList<String>> modelIds = new HashMap<Module, ArrayList<String>>();
        try {
            for (Map.Entry<String, Module> moduleEntry : this.getDependingModules().entrySet()) {
                XSLTTransformSource source = (XSLTTransformSource)this.getSource(moduleEntry.getKey());
                Node node = XSLTTransformSource.getNode(source.getXSLTTransformSource());
                Element model = node instanceof Document ? ((Document)node).getDocumentElement() : (Element)node;
                modelIds.put(moduleEntry.getValue(), this.getModelIds(model));
            }
            Helpers helpers = new Helpers();
            InputStream base = Models.class.getResourceAsStream("E2E Bridge Base.xml");
            Element baseElement = DomUtilities.parse((InputStream)base, (boolean)false, (boolean)false, (boolean)true).getDocumentElement();
            modelIds.put(helpers.getModuleFactory().getModule(new File("/<install.root>/modelLibraries/E2E Bridge Base.xml"), "E2E Bridge Base.xml"), this.getModelIds(baseElement));
            this.result = this.createDocument(this.getSourceElement(), this.getModuleName(), this.getModuleId(), modelIds, new File(this.getSourceManager().getWorkFolder(), "uml"), this.getLibrariesIDLSources());
            DomUtilities.serialize((File)this.getDestinationFile(), (Document)this.result, (boolean)true);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Document createDocument(Element model, String moduleName, String moduleId, HashMap<Module, ArrayList<String>> modelIds, File srcFolder, HashMap<String, IDLSource> idlSources) throws XPathExpressionException {
        model.setAttribute("xmi:id", moduleId);
        ArrayList<Module> moduleSet = new ArrayList<Module>(XmiTransformationModelHelper.replaceXumlIdRefs(model, moduleName, idlSources, this.getErrorHandler()));
        XmiTransformationModelHelper.replaceIdRefs(model, modelIds);
        moduleSet.addAll(modelIds.keySet().stream().filter(module -> !module.getName().equals("E2E Bridge Base.xml")).collect(Collectors.toSet()));
        Document document = DomUtilities.newDocument();
        Node importedNode = document.importNode(model, true);
        document.appendChild(importedNode);
        if (!moduleSet.isEmpty()) {
            Element mountTable = document.createElement("mountTable");
            moduleSet.sort(Comparator.comparing(Module::getName));
            for (Module mountedModule : moduleSet) {
                mountTable.appendChild(mountedModule.toXmi(document, model.getAttribute("xmi:id"), srcFolder.getPath()));
            }
            document.getDocumentElement().appendChild(mountTable);
        }
        Element shareTable = document.createElement("shareTable");
        Element share = document.createElement("share");
        String rootPackage = (String)DomUtilities.evaluate((Node)model, (String)"datamodel/packagedElement/@xmi:id", (QName)XPathConstants.STRING);
        share.setAttribute("sharedPackage", rootPackage);
        shareTable.appendChild(share);
        document.getDocumentElement().appendChild(shareTable);
        return document;
    }
}

