/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.FileSource;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.builder.compiler.document.JsonDocument;
import ch.e2e.builder.compiler.document.json.bpmn.BpmnDefinitions;
import ch.e2e.builder.compiler.document.json.library.LibraryDescriptor;
import ch.e2e.builder.compiler.document.json.library.LibraryForm;
import ch.e2e.builder.compiler.document.json.xuml.XumlActionScript;
import ch.e2e.builder.compiler.document.json.xuml.XumlActivity;
import ch.e2e.builder.compiler.document.json.xuml.XumlArtifact;
import ch.e2e.builder.compiler.document.json.xuml.XumlClass;
import ch.e2e.builder.compiler.document.json.xuml.XumlCompilerConfig;
import ch.e2e.builder.compiler.document.json.xuml.XumlExecution;
import ch.e2e.builder.compiler.document.json.xuml.XumlInterface;
import ch.e2e.builder.compiler.document.json.xuml.XumlLibraryUsage;
import ch.e2e.builder.compiler.document.json.xuml.XumlMapping;
import ch.e2e.builder.compiler.document.json.xuml.XumlPackage;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import ch.e2e.builder.compiler.document.json.xuml.component.XumlComponents;
import ch.e2e.builder.compiler.document.json.xuml.form.XumlForm;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.w3c.dom.Node;

public class Json2XmlTask
extends CacheAbleTask
implements JsonDocumentSource,
XSLTTransformSource {
    private JsonDocument jsonDocument;
    private DOMResult result;

    public static Boolean select(String id) {
        return id.endsWith(".xml");
    }

    public Json2XmlTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getSourceId());
        return result;
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".xml";
    }

    private String getSourceId() {
        return this.getDestinationFilePathWithoutExtension() + ".json";
    }

    private Class<? extends JsonDocument> getType() {
        String id = this.getDestinationFilePathWithoutExtension();
        if (id.equals("project")) {
            return XumlProject.class;
        }
        if (id.endsWith(".activity")) {
            return XumlActivity.class;
        }
        if (id.endsWith(".library")) {
            return XumlLibraryUsage.class;
        }
        if (id.endsWith(".bpmn")) {
            return BpmnDefinitions.class;
        }
        if (id.endsWith(".execution")) {
            return XumlExecution.class;
        }
        if (id.endsWith(".mapping")) {
            return XumlMapping.class;
        }
        if (id.endsWith(".actionScript")) {
            return XumlActionScript.class;
        }
        if (id.endsWith(".class")) {
            return XumlClass.class;
        }
        if (id.endsWith(".interface")) {
            return XumlInterface.class;
        }
        if (id.endsWith(".package")) {
            return XumlPackage.class;
        }
        if (id.endsWith(".library.form")) {
            return LibraryForm.class;
        }
        if (id.endsWith(".form")) {
            return XumlForm.class;
        }
        if (id.endsWith(".descriptor")) {
            return LibraryDescriptor.class;
        }
        if (id.endsWith(".artifact")) {
            return XumlArtifact.class;
        }
        if (id.equals("compiler.config")) {
            return XumlCompilerConfig.class;
        }
        if (id.endsWith(".components")) {
            return XumlComponents.class;
        }
        return null;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        Class<? extends JsonDocument> type = this.getType();
        FileSource source = (FileSource)this.getSource(this.getSourceId());
        if (source == null) {
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(source.getFile());){
            HashMap jaxbProperties = new HashMap();
            JAXBContext jaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{type}, jaxbProperties);
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            jaxbUnmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            jaxbUnmarshaller.setProperty("eclipselink.json.include-root", (Object)false);
            this.jsonDocument = (JsonDocument)jaxbUnmarshaller.unmarshal((Source)new StreamSource(fileInputStream), type).getValue();
            if (!this.getErrorHandler().hasErrors()) {
                this.transform(this.jsonDocument);
            }
            if (!this.getErrorHandler().hasErrors()) {
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                this.getDestinationFile().getParentFile().mkdirs();
                this.getDestinationFile().createNewFile();
                this.result = new DOMResult();
                jaxbMarshaller.marshal((Object)this.jsonDocument, (Result)this.result);
                DomUtilities.serialize((File)this.getDestinationFile(), (Node)this.result.getNode(), (boolean)true);
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    protected void transform(JsonDocument jsonDocument) {
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new StreamSource(this.getDestinationFile());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public <T extends JsonDocument> T getJsonDocument(Class<T> type) {
        if (this.jsonDocument == null) {
            if (!this.isExecuted()) {
                this.execute();
            }
            if (this.isUpToDate()) {
                try {
                    HashMap jaxbProperties = new HashMap();
                    JAXBContext jaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{type}, jaxbProperties);
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    this.jsonDocument = (JsonDocument)jaxbUnmarshaller.unmarshal((Source)new StreamSource(this.getDestinationFile()), type).getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return (T)this.jsonDocument;
    }
}

