/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular.typescript.dataModel;

import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularXsltTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlClass;
import java.util.HashSet;
import java.util.Set;

public class InterfaceTypescriptTask
extends AngularXsltTask {
    private final String classSourceId = this.getDestinationFilePathWithoutExtension().replace(this.getSourceLibPath(), "") + ".class.xml";

    public static Boolean select(String id) {
        return id.endsWith(".interface.ts.xml");
    }

    public InterfaceTypescriptTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".interface.ts.xml";
    }

    @Override
    protected String getTransformerId() {
        return "model.angular.typescript.interface";
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.classSourceId);
        return result;
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.classSourceId);
        JsonDocumentSource classSource = (JsonDocumentSource)this.getSourceManager().getSource(this.classSourceId);
        XumlClass xumlClass = classSource.getJsonDocument(XumlClass.class);
        xumlClass.getAttributes().stream().filter(xumlProperty -> xumlProperty.getType() != null && xumlProperty.getType().contains(".library.json#")).forEach(xumlProperty -> result.add(xumlProperty.getType().substring(0, xumlProperty.getType().indexOf(".library.json#")) + ".library.ts.imports.xml"));
        if (xumlClass.getGeneral() != null && xumlClass.getGeneral().getType() != null && xumlClass.getGeneral().getType().contains(".library.json#")) {
            result.add(xumlClass.getGeneral().getType().substring(0, xumlClass.getGeneral().getType().indexOf(".library.json#")) + ".library.ts.imports.xml");
        }
        return result;
    }
}

