/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular.clean;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.MultipleOutputsCacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularHelper;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import ch.e2e.io.FileUtilities;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AngularCleanWorkspaceTask
extends MultipleOutputsCacheAbleTask {
    private static final String EXTENSION_REGEX = "(\\..*)*";

    public AngularCleanWorkspaceTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".clean";
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add("project.xml");
        return result;
    }

    protected String getProjectName() {
        return ((JsonDocumentSource)this.getSourceManager().getSource("project.xml")).getJsonDocument(XumlProject.class).getName();
    }

    protected String getAngularProjectName() {
        if (this.isLib().booleanValue()) {
            return AngularHelper.getAngularLibName(this.getProjectName());
        }
        return AngularHelper.getMainProjectName(this.getProjectName());
    }

    protected Boolean isLib() {
        return this.getId().startsWith("angular-lib");
    }

    protected Set<String> getProjectDirectories() {
        return new HashSet<String>();
    }

    protected Set<String> getUpToDateProjects() throws Exception {
        return new HashSet<String>();
    }

    protected Set<String> getOutdatedFiles() throws Exception {
        return new HashSet<String>();
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            Set<String> upToDateAngularProjects = this.getUpToDateProjects();
            for (String path : this.getProjectDirectories()) {
                Path projectDirectory = this.getSourceManager().getWorkFolder().toPath().resolve(path);
                if (!Files.exists(projectDirectory, new LinkOption[0]) || !Files.isDirectory(projectDirectory, new LinkOption[0])) break;
                this.cleanSubFolders(projectDirectory, upToDateAngularProjects);
            }
            this.cleanFiles();
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    private void cleanSubFolders(Path projectDirectory, Set<String> upToDateAngularProjects) throws Exception {
        Path workFolderPath = this.getSourceManager().getWorkFolder().toPath();
        Files.walk(projectDirectory, 1, new FileVisitOption[0]).filter(path -> {
            String id = workFolderPath.relativize((Path)path).toString().replace(System.getProperty("file.separator"), "/");
            return !projectDirectory.equals(path) && upToDateAngularProjects.stream().noneMatch(upToDateAngularProjectId -> id.matches(upToDateAngularProjectId + EXTENSION_REGEX));
        }).map(Path::toFile).filter(File::isDirectory).forEach(file -> {
            try {
                FileUtilities.deleteDirectory((File)file);
            }
            catch (Exception e) {
                this.getErrorHandler().error((Throwable)e);
            }
        });
    }

    private void cleanFiles() throws Exception {
        this.getOutdatedFiles().stream().map(id -> new File(this.getSourceManager().getWorkFolder(), (String)id)).filter(file -> file.exists() && file.isFile()).forEach(File::delete);
    }

    @Override
    public boolean isUpToDate() {
        return false;
    }

    @Override
    protected Set<String> getDestinationFiles() {
        try {
            return this.getUpToDateProjects();
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
            return Collections.emptySet();
        }
    }
}

