/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular;

import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularXsltTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;

public class RootPackageJson
extends AngularXsltTask {
    public static Boolean select(String id) {
        return id.equals("angular/package.json.xml");
    }

    public RootPackageJson(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".json.xml";
    }

    @Override
    protected String getTransformerId() {
        return "model.angular.json.package.app";
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(CompilerConstants.SOURCE_TEMPLATE_RESOURCE_BASE_PATH + this.getDestinationFilePathWithoutExtension() + ".base.json");
        result.add("project.xml");
        try {
            Path projectPath = this.getSourceManager().getProjectFolder().toPath();
            this.sourceManager.getSourceFilesStream().filter(path -> {
                String s = projectPath.relativize((Path)path).toString().replace(System.getProperty("file.separator"), "/");
                return s.endsWith(".library.json");
            }).forEach(path -> {
                String filename = path.getFileName().toString();
                result.add(Files.libs_LIBRARY__library_descriptor_xml(filename.substring(0, filename.length() - ".library.json".length())));
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

