/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular;

import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularZipTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;

public class AngularZipSourcesTask
extends AngularZipTask {
    private static final String[] EXTENSIONS_TO_FILTER_OUT = new String[]{".hash", ".errors", ".sources", ".npm", ".file.list", ".clean", ".ts.xml", ".html.xml", ".json.xml", ".log.txt"};

    public static Boolean select(String id) {
        return id.equals("angular.zip") || id.equals("angular-lib.zip");
    }

    public AngularZipSourcesTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doFilter(Path path) {
        Path basePath = this.getInputFolderPaths()[0];
        if (!super.doFilter(path)) return false;
        if (path.startsWith(basePath.resolve("node_modules"))) return false;
        if (path.startsWith(basePath.resolve(".angular"))) return false;
        if (path.startsWith(basePath.resolve("dist"))) return false;
        if (!Stream.of(EXTENSIONS_TO_FILTER_OUT).noneMatch(path.getFileName().toString()::endsWith)) return false;
        return true;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add(this.getDestinationFilePathWithoutExtension() + ".file.list");
        return result;
    }
}

