/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularHelper;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularZipTask;
import ch.e2e.builder.compiler.build.tasks.source.InputStreamSource;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;

public class AngularZipDistTask
extends AngularZipTask {
    public static Boolean select(String id) {
        return id.matches(ch.e2e.builder.compiler.build.tasks.constants.Files.angular_dist__PROJECT_zip(AngularHelper.getMainProjectName("(.*)")));
    }

    public AngularZipDistTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    protected InputStream getDummyMainZipInputStream() throws IOException {
        Source inputStreamSource = this.getSourceManager().getSource(CompilerConstants.SOURCE_TEMPLATE_RESOURCE_BASE_PATH + ch.e2e.builder.compiler.build.tasks.constants.Files.angular_dist__PROJECT_main_zip("__PROJECT_NAME__"));
        if (inputStreamSource instanceof InputStreamSource) {
            return ((InputStreamSource)inputStreamSource).getInputStream();
        }
        return null;
    }

    protected boolean isExplicitAngularApp() {
        Path projectPath = this.getSourceManager().getProjectFolder().toPath();
        XumlProject projectDocument = ((JsonDocumentSource)this.getSourceManager().getSource("project.xml")).getJsonDocument(XumlProject.class);
        try {
            if (projectDocument.getApplication().getGenerateApplication().toLowerCase().equals("always") || projectDocument.getApplication().getGenerateApplication().toLowerCase().equals("ifforms") && Files.walk(projectPath, new FileVisitOption[0]).anyMatch(path -> path.toString().endsWith(".form.json"))) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            if (this.isExplicitAngularApp()) {
                super.executeTask(dependencyLevel);
            } else {
                Path destinationFile = this.getDestinationFile().toPath();
                Files.createDirectories(destinationFile.getParent(), new FileAttribute[0]);
                Files.copy(this.getDummyMainZipInputStream(), destinationFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        if (this.isExplicitAngularApp()) {
            result.add(ch.e2e.builder.compiler.build.tasks.constants.Files.angular_projects__PROJECT_build_npm(AngularHelper.getMainProjectName(this.getProjectName())));
        }
        return result;
    }
}

