/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.CompilationProperties;
import ch.e2e.builder.compiler.build.tasks.ExecuteProcessTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.builder.compiler.utils.EnvUtils;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AngularNpmTask
extends ExecuteProcessTask {
    public static final String NUMBER_OF_THREADS = "xuml_parallel_npm_task_number-of-threads";
    public static final String TIMEOUT_TIME = "xuml_parallel_npm_task_timeout-time";
    public static final String TIMEOUT_UNIT = "xuml_parallel_npm_task_timeout-unit";
    public static final String MAX_QUEUE_SIZE = "xuml_parallel_npm_task_max-queue-size";
    private static final ThreadPoolExecutor PARALLEL_TASK_THREAD_POOL = (ThreadPoolExecutor)Executors.newFixedThreadPool(EnvUtils.get("xuml_parallel_npm_task_number-of-threads", CompilationProperties.getInstance().getInt("xuml_parallel_npm_task_number-of-threads")));
    static String npm = CompilerConstants.isWindows() ? "npm.cmd" : "npm";

    public AngularNpmTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    protected String getNpmArguments() {
        return "";
    }

    @Override
    protected String getCommand() {
        return npm + " " + this.getNpmArguments();
    }

    @Override
    protected File getDir() {
        return this.getSourceManager().getWorkFolder().toPath().toAbsolutePath().resolve("angular").toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        Future<?> result = null;
        AtomicReference<Process> npmSubProcessReference = new AtomicReference<Process>();
        try {
            if (PARALLEL_TASK_THREAD_POOL.getQueue().size() > this.getMaxQueueSize()) {
                throw new BuildException("Parallel tasks queue size exceeded");
            }
            result = PARALLEL_TASK_THREAD_POOL.submit(() -> super.executeProcess(npmSubProcessReference));
            result.get(this.getTimeoutTime(), this.getTimeoutUnit());
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
            Optional.ofNullable(result).filter(r -> !r.isDone()).ifPresent(r -> r.cancel(true));
        }
        finally {
            this.killProcess(npmSubProcessReference);
        }
    }

    protected int getMaxQueueSize() {
        return EnvUtils.get(MAX_QUEUE_SIZE, CompilationProperties.getInstance().getInt(MAX_QUEUE_SIZE));
    }

    protected int getTimeoutTime() {
        return EnvUtils.get(TIMEOUT_TIME, CompilationProperties.getInstance().getInt(TIMEOUT_TIME));
    }

    protected TimeUnit getTimeoutUnit() {
        return TimeUnit.valueOf(EnvUtils.get(TIMEOUT_UNIT, AngularNpmTask.getCompilationProperty(TIMEOUT_UNIT)));
    }
}

