/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.library2class;

import ch.e2e.builder.compiler.build.tasks.SplitXmlDocumentUsingXpathTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.io.File;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class LibraryClasses2ClassXmlTask
extends SplitXmlDocumentUsingXpathTask {
    public static Boolean select(String id) {
        return id.endsWith(".class.xml") && id.startsWith("libs");
    }

    public LibraryClasses2ClassXmlTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".class.xml";
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getSourcePath());
        return result;
    }

    @Override
    protected String getSourcePath() {
        File tmp;
        File libraryFolder = this.getDestinationFile();
        while (Objects.nonNull(libraryFolder) && !(tmp = libraryFolder.getParentFile()).getName().equals("libs")) {
            libraryFolder = tmp;
        }
        return "libs/" + libraryFolder.getName() + ".library.classes.xml";
    }

    @Override
    protected String getSplitXpathExpression() {
        return String.format("//xuml:result/xuml:class[@file-path='%s']", this.getId());
    }
}

