/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.libraries;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibrariesHelper;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibraryIdlMap;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.LibraryIdlMapSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.library.LibraryDescriptor;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.w3c.dom.Node;

public class LibraryIdlMapTask
extends CacheAbleTask
implements LibraryIdlMapSource {
    public static String LibraryIdlMapTask_ID = "libs/libraryIdlMap.xml";
    LibraryIdlMap libraryIdlMap = null;

    public static Boolean select(String id) {
        return id.equals(LibraryIdlMapTask_ID);
    }

    public LibraryIdlMapTask(SourceManager sourceManager, String id) {
        super(sourceManager, LibraryIdlMapTask_ID);
    }

    protected Set<String> getDescriptorsSourceSet() {
        return LibrariesHelper.getDescriptorsSourceSet(this.getSourceManager());
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getBeforeSourceSet();
        result.addAll(this.getDescriptorsSourceSet());
        return result;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            this.libraryIdlMap = new LibraryIdlMap();
            this.getDescriptorsSourceSet().forEach(s -> {
                JsonDocumentSource source = (JsonDocumentSource)this.getSource((String)s);
                LibraryDescriptor descriptor = source.getJsonDocument(LibraryDescriptor.class);
                if (descriptor.getContent().getImplementation() != null) {
                    String ext = null;
                    switch (descriptor.getContent().getImplementation()) {
                        case xml: {
                            ext = ".library.idl.xml";
                            break;
                        }
                        case json: {
                            ext = ".library.idl.json";
                            break;
                        }
                        case lrep: {
                            ext = ".library.lrep.idl.xml";
                        }
                    }
                    this.libraryIdlMap.map.put(descriptor.getName(), "libs/" + descriptor.getName() + "/" + descriptor.getName() + ext);
                }
            });
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{LibraryIdlMap.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            DOMResult result = new DOMResult();
            jaxbMarshaller.marshal((Object)this.libraryIdlMap, (Result)result);
            DomUtilities.serialize((File)this.getDestinationFile(), (Node)result.getNode(), (boolean)true);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    @Override
    public LibraryIdlMap getLibraryIdlMap() {
        if (this.libraryIdlMap == null) {
            if (!this.isExecuted()) {
                this.execute();
            }
            if (this.isUpToDate()) {
                try {
                    JAXBContext jaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{LibraryIdlMap.class}, new HashMap());
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    this.libraryIdlMap = (LibraryIdlMap)jaxbUnmarshaller.unmarshal((Source)new StreamSource(this.getDestinationFile()), LibraryIdlMap.class).getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.libraryIdlMap;
    }
}

