/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.dev;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.model.dev.DevUtils;
import ch.e2e.builder.compiler.build.tasks.rest.RestTask;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlCompilerConfig;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;

public abstract class DevTask
extends RestTask {
    public DevTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add("compiler.config.xml");
        result.add("dev.start.environment");
        return result;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        if (DevUtils.isDevEnvEnabled()) {
            super.executeTask(dependencyLevel);
        }
    }

    @Override
    protected String getBaseUrl() {
        XumlCompilerConfig compilerConfig = ((JsonDocumentSource)this.getSourceManager().getSource("compiler.config.xml")).getJsonDocument(XumlCompilerConfig.class);
        return DevUtils.getDevServicePath(compilerConfig.getProjectId(), compilerConfig.getDevServicePort());
    }

    @Override
    protected String getMethod() {
        return "POST";
    }

    @Override
    protected void handleResponse(Response response) throws Exception {
        Path file = this.getDestinationFile().toPath();
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            if (Files.notExists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
            Files.write(file, new Date().toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Entity<?> getEntity() {
        return Entity.json((Object)"{}");
    }

    @Override
    public boolean isUpToDate() {
        return super.isUpToDate() && !this.getErrorHandler().hasErrors();
    }
}

