/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.dev;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.model.dev.DevUtils;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlCompilerConfig;
import ch.e2e.builder.compiler.serviceRepository.ServiceRepositoryService;
import ch.e2e.builder.compiler.serviceRepository.types.events.DeployContainerResponse;
import ch.e2e.builder.compiler.tools.CompilerConstants;
import ch.e2e.builder.compiler.utils.ClientUtils;
import ch.e2e.builder.compiler.utils.EnvUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlRootElement;

public class DevStartEnvironmentTask
extends CacheAbleTask {
    private static final String imageName = EnvUtils.get("xuml_development_service_image", "scheer-docker-registry:5000/pas/xuml-development-service:latest");
    private static final int startupTimeout = EnvUtils.get("xuml_development_service_startup_timeout", 20);
    private static final String WINDOWS_COMMAND_FORMAT = "START /B npm run start";
    private static final String LINUX_COMMAND_FORMAT = "npm run start &";
    public static final String TASK_ID = "dev.start.environment";

    public static Boolean select(String id) {
        return id.matches(TASK_ID);
    }

    public DevStartEnvironmentTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add("compiler.config.xml");
        return result;
    }

    protected String getDevBaseUrl() {
        XumlCompilerConfig compilerConfig = ((JsonDocumentSource)this.getSourceManager().getSource("compiler.config.xml")).getJsonDocument(XumlCompilerConfig.class);
        return DevUtils.getDevServicePath(compilerConfig.getProjectId(), compilerConfig.getDevServicePort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        if (DevUtils.isDevEnvEnabled()) {
            Result result = new Result();
            String projectId = this.getSourceManager().getProjectFolder().getName();
            try {
                XumlCompilerConfig compilerConfig = ((JsonDocumentSource)this.getSourceManager().getSource("compiler.config.xml")).getJsonDocument(XumlCompilerConfig.class);
                DevStartEnvironmentTask.startXumlDevelopmentService(compilerConfig);
                result.setDeployResponse(DevUtils.STARTED_DEV_SERVICES.get(projectId));
                for (int i = 0; i < startupTimeout && !this.compileControl.shouldAbortTask(this.getTaskInfo(), dependencyLevel); ++i) {
                    if (i > 0) {
                        Thread.sleep(1000L);
                    }
                    Logging.logger.info("try access development service...");
                    if (!this.isRunning()) continue;
                    result.setHealthCheck(new Date());
                    return;
                }
                Logging.logger.warning("development service could not be reached...");
                this.getErrorHandler().error((Throwable)new BuildException("Development service could not be reached"));
            }
            catch (Exception e) {
                this.getErrorHandler().error((Throwable)e);
            }
            finally {
                this.marshalXmlToFile(result, this.getDestinationFile());
            }
        }
    }

    public static void startXumlDevelopmentService(XumlCompilerConfig compilerConfig) throws Exception {
        if (DevUtils.isLocalDevEnv()) {
            if (!DevUtils.STARTED_DEV_SERVICES.containsKey(compilerConfig.getProjectId())) {
                DevStartEnvironmentTask.startLocalXumlDevelopmentService(compilerConfig);
            }
        } else if (!DevUtils.STARTED_DEV_SERVICES.containsKey(compilerConfig.getProjectId())) {
            DevStartEnvironmentTask.startContainerXumlDevelopmentService(compilerConfig);
        }
    }

    private static void startContainerXumlDevelopmentService(XumlCompilerConfig compilerConfig) throws Exception {
        ServiceRepositoryService serviceRepository = new ServiceRepositoryService();
        DeployContainerResponse deployContainerResponse = serviceRepository.deployContainer(imageName, DevUtils.getContainerDevName(compilerConfig.getProjectId()), DevUtils.getContainerDevName(compilerConfig.getProjectId()));
        DevUtils.STARTED_DEV_SERVICES.put(compilerConfig.getProjectId(), deployContainerResponse);
    }

    private static void startLocalXumlDevelopmentService(XumlCompilerConfig compilerConfig) throws Exception {
        int port = compilerConfig.getDevServicePort();
        int servePort = compilerConfig.getDevServiceServePort();
        String projectId = compilerConfig.getProjectId();
        Path devWorkspacePath = DevUtils.getLocalDevFolderPath().toAbsolutePath().resolve(projectId);
        File devWorkspaceFile = devWorkspacePath.toFile();
        devWorkspaceFile.mkdirs();
        List<String> command = CompilerConstants.isWindows() ? Arrays.asList("cmd", "/c", WINDOWS_COMMAND_FORMAT) : Arrays.asList("bash", "-c", LINUX_COMMAND_FORMAT);
        ProcessBuilder process = new ProcessBuilder(new String[0]);
        Map<String, String> env = process.environment();
        env.put("port", port + "");
        env.put("servePort", servePort + "");
        env.put("sourceRoot", devWorkspacePath.toString());
        process.redirectOutput(new File(devWorkspaceFile, "log.txt"));
        process.redirectError(new File(devWorkspaceFile, "log.txt"));
        process.command(command).directory(DevUtils.getLocalDevServiceFolderPath().toFile()).start();
        DevUtils.STARTED_DEV_SERVICES.put(projectId, null);
    }

    private boolean isRunning() {
        Client client = ClientUtils.getClient();
        try {
            Response response = client.target(this.getDevBaseUrl()).path("health").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).buildGet().invoke();
            if (response != null) {
                return true;
            }
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isUpToDate() {
        if (!super.isUpToDate() || this.getErrorHandler().hasErrors()) {
            return false;
        }
        return this.isRunning();
    }

    @XmlRootElement
    public static class Result {
        private DeployContainerResponse deployResponse;
        private Date healthCheck;

        public DeployContainerResponse getDeployResponse() {
            return this.deployResponse;
        }

        public void setDeployResponse(DeployContainerResponse deployResponse) {
            this.deployResponse = deployResponse;
        }

        public Date getHealthCheck() {
            return this.healthCheck;
        }

        public void setHealthCheck(Date healthCheck) {
            this.healthCheck = healthCheck;
        }
    }
}

