/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.build.tasks.source.XSLTTransformSource;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XmlPartsExtractionTask
extends CacheAbleTask
implements XSLTTransformSource {
    public XmlPartsExtractionTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".xml";
    }

    @Override
    protected Set<String> getSourceSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.getSourcePath());
        return result;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            XSLTTransformSource source = (XSLTTransformSource)this.getSource(this.getSourcePath());
            Node node = XSLTTransformSource.getNode(source.getXSLTTransformSource());
            Element model = node instanceof Document ? ((Document)node).getDocumentElement() : (Element)node;
            Document newDocument = DomUtilities.newDocument();
            Node rootNode = newDocument;
            if (this.getRootElementName() != null) {
                rootNode = newDocument.createElement(this.getRootElementName());
                newDocument.appendChild(rootNode);
            }
            Map<String, String> namespaces = this.getNamespaces();
            for (String partXpath : this.getPartsToExtractXpath()) {
                for (Node partNote : DomUtilities.selectNodes((Node)model, (String)partXpath, namespaces)) {
                    Node importedNode = newDocument.importNode(partNote, true);
                    rootNode.appendChild(importedNode);
                }
            }
            Path filePath = Paths.get(this.getSourceManager().getWorkFolder().getPath(), this.getId());
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            DomUtilities.serialize((File)filePath.toFile(), (Document)newDocument, (boolean)true);
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    protected abstract String getSourcePath();

    protected abstract Set<String> getPartsToExtractXpath();

    protected String getRootElementName() {
        return null;
    }

    protected Map<String, String> getNamespaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xuml", "http://scheer-group.com/xuml");
        return namespaces;
    }

    @Override
    public Source getXSLTTransformSource() {
        try {
            return new DOMSource(DomUtilities.parse((File)this.getDestinationFile(), (boolean)false, (boolean)false));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

