/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.InputStreamSource;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.util.StringTools;
import ch.e2e.xuml.utils.LineWithSeparatorReaderImpl;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public abstract class SubstitutionTask
extends CacheAbleTask {
    public SubstitutionTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    protected abstract String getSourceId();

    protected InputStream getSubstitutionInputStream() throws IOException {
        Source inputStreamSource = this.getSource(this.getSourceId());
        if (inputStreamSource instanceof InputStreamSource) {
            return ((InputStreamSource)inputStreamSource).getInputStream();
        }
        return null;
    }

    protected Map<String, String> getSubstitutions() {
        return new HashMap<String, String>();
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        try {
            this.getDestinationFile().delete();
            this.getDestinationFile().getParentFile().mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(this.getDestinationFile()));
             LineWithSeparatorReaderImpl lineReader = new LineWithSeparatorReaderImpl((Reader)new InputStreamReader(this.getSubstitutionInputStream()));){
            String line;
            String beginToken = this.getBeginToken();
            String endToken = this.getEndToken();
            Map<String, String> substitutions = this.getSubstitutions();
            while ((line = lineReader.readLineWithSeparator()) != null) {
                line = StringTools.replaceProperties((String)line, substitutions, (String)beginToken, (String)endToken);
                writer.write(line);
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    protected String getBeginToken() {
        return "${";
    }

    protected String getEndToken() {
        return "}";
    }
}

