/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.InputStreamSource;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

public abstract class MergeJsonTask
extends CacheAbleTask {
    public MergeJsonTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        return new HashSet<String>(this.getSourcesToMerge());
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".json";
    }

    protected abstract Set<String> getSourcesToMerge();

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        JsonWriterFactory jsonWriterFactory = Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
        try {
            Files.createDirectories(this.getDestinationFile().toPath().getParent(), new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try (JsonWriter jsonWriter = jsonWriterFactory.createWriter((OutputStream)new FileOutputStream(this.getDestinationFile()));){
            JsonObjectBuilder mergedJson = Json.createObjectBuilder();
            this.getSourcesToMerge().forEach(sourceId -> {
                try (InputStream sourceToMerge = this.getInputStream((String)sourceId);){
                    mergedJson.addAll(Json.createObjectBuilder((JsonObject)Json.createReader((InputStream)sourceToMerge).readObject()));
                }
                catch (Exception e) {
                    this.getErrorHandler().error((Throwable)e);
                }
            });
            jsonWriter.writeObject(mergedJson.build());
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
    }

    private InputStream getInputStream(String sourceId) throws IOException {
        Source inputStreamSource = this.getSource(sourceId);
        if (inputStreamSource instanceof InputStreamSource) {
            return ((InputStreamSource)inputStreamSource).getInputStream();
        }
        return null;
    }
}

