/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.compiler.build.tasks.MultipleOutputsCacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.utils.EnvUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public abstract class ExecuteProcessTask
extends MultipleOutputsCacheAbleTask {
    private static final String EXECUTE_PROCESS_TASK_STREAMS_TO_FILES_ENABLED = "ExecuteProcessTask.streams.to.files.enabled";
    private Path outputLogPath;
    private Path errorLogPath;
    private String errors = "";

    public ExecuteProcessTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
        this.outputLogPath = sourceManager.getWorkFolder().toPath().resolve(id + ".log.txt");
        this.errorLogPath = sourceManager.getWorkFolder().toPath().resolve(id + ".errors" + ".log.txt");
    }

    protected abstract String getCommand();

    protected abstract File getDir();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeProcess(AtomicReference<Process> processReference) {
        try {
            Process process = Runtime.getRuntime().exec(this.getCommand(), null, this.getDir());
            processReference.set(process);
            do {
                process.waitFor(100L, TimeUnit.MILLISECONDS);
                String error = ExecuteProcessTask.getStreamMessage(process.getErrorStream());
                if (error != null && !error.equals("")) {
                    this.errors = this.errors + error;
                }
                if (!EnvUtils.get(EXECUTE_PROCESS_TASK_STREAMS_TO_FILES_ENABLED, Boolean.getBoolean("ch.e2e.builder.development"))) continue;
                String output = ExecuteProcessTask.getStreamMessage(process.getInputStream());
                if (output != null && !output.equals("")) {
                    ExecuteProcessTask.log(output, this.outputLogPath);
                }
                if (error == null || error.equals("")) continue;
                ExecuteProcessTask.log(error, this.errorLogPath);
            } while (process.isAlive());
            if (process.exitValue() != 0) {
                this.getErrorHandler().error((Throwable)new ExecuteProcessException(this.errors));
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error((Throwable)e);
        }
        finally {
            this.killProcess(processReference);
        }
    }

    protected void killProcess(AtomicReference<Process> processReference) {
        Optional.ofNullable(processReference).map(AtomicReference::get).filter(Process::isAlive).ifPresent(Process::destroyForcibly);
    }

    private static String getStreamMessage(InputStream stream) {
        String date = new Date().toString() + ": ";
        String errorMessage = null;
        try {
            errorMessage = new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n" + date));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (errorMessage != null && !errorMessage.equals("")) {
            errorMessage = date + errorMessage + "\n";
        }
        return errorMessage;
    }

    private static void log(String logMessage, Path logFile) {
        try {
            Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
            if (Files.notExists(logFile, new LinkOption[0])) {
                Files.createFile(logFile, new FileAttribute[0]);
            }
            Files.write(logFile, logMessage.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ExecuteProcessException
    extends Throwable {
        public ExecuteProcessException(String message) {
            super(message);
        }
    }
}

