/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractBuilderError;
import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.CompileConfigurationTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.types.Deploy;
import ch.e2e.builder.compiler.build.types.Parameter;
import ch.e2e.builder.compiler.build.types.Repository;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.error.DeployError;
import ch.e2e.builder.compiler.net.BridgeApiResultParser;
import ch.e2e.builder.compiler.net.BridgeResultError;
import ch.e2e.builder.compiler.net.Login;
import ch.e2e.builder.compiler.net.LoginFailedException;
import ch.e2e.secure.HttpsUtil;
import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class DeployRepositoryTask
extends CompileConfigurationTask {
    private Deploy deploy;
    private Map<String, String> replaceMap = new HashMap<String, String>();

    public DeployRepositoryTask(CompileControl ... controls) {
        super(controls);
    }

    public void setDeploy(Deploy deploy) {
        this.deploy = deploy;
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        block18: {
            WebTarget target = null;
            try (Client client = null;){
                Login login = this.deploy.getLogin();
                this.getReplaceMap().put("url", login.getUrl());
                client = ((ClientBuilder)ClientBuilder.newBuilder().sslContext(HttpsUtil.getSSLContext()).register(MultiPartFeature.class)).build();
                target = client.target(this.createUri(login));
                MultiPart multiPart = this.uploadFiles();
                String authorizationHeader = "";
                if (login.getBearer() != null && !login.getBearer().equals("")) {
                    authorizationHeader = "Bearer " + login.getBearer();
                } else {
                    if (login.getPassword() == null || login.getPassword().length() == 0) {
                        login.askForPassword();
                    }
                    String encoding = Base64.getEncoder().encodeToString((login.getUsername() + ":" + login.getPassword()).getBytes(StandardCharsets.UTF_8));
                    authorizationHeader = "Basic " + encoding;
                }
                Invocation invocation = target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)authorizationHeader).buildPost(Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType()));
                Response response = invocation.invoke();
                this.checkAnswer(response);
            }
        }
    }

    private URI createUri(Login login) {
        String url = login.getUrl();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)url).path(this.getProperty("deploy.configuration.api.path"));
        for (Parameter param : this.deploy.getParameter()) {
            switch (param.getName()) {
                case "input_overwrite": {
                    uriBuilder = uriBuilder.queryParam("overwrite", new Object[]{param.getValue()});
                    break;
                }
                case "input_overwrite_settings": {
                    uriBuilder = uriBuilder.queryParam("overwritePrefs", new Object[]{param.getValue()});
                    break;
                }
                case "input_startup": {
                    uriBuilder = uriBuilder.queryParam("startup", new Object[]{param.getValue()});
                }
            }
        }
        return uriBuilder.build(new Object[0]);
    }

    private MultiPart uploadFiles() {
        File rep = null;
        for (CompilableObject compilableObject : this.getCompilableObjects()) {
            this.getReplaceMap().put("composite.name", compilableObject.getName());
            Repository repository = this.getRepository(compilableObject);
            for (Deployment deployment : compilableObject.getDeployments()) {
                rep = repository.getTargetFile(deployment);
            }
        }
        FileDataBodyPart uploadFile = new FileDataBodyPart("uploadFile", rep, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return new FormDataMultiPart().bodyPart((BodyPart)uploadFile);
    }

    public Map<String, String> getReplaceMap() {
        return this.replaceMap;
    }

    private void checkAnswer(Response response) {
        try {
            int status = response.getStatus();
            if (status == 401 || status == 403) {
                throw new LoginFailedException();
            }
            BridgeApiResultParser resultParser = new BridgeApiResultParser((String)response.readEntity(String.class));
            for (BridgeResultError error : resultParser.getErrors()) {
                DeployError deployError = this.createError(error);
                this.getErrorHandler().error((AbstractBuilderError)deployError);
            }
        }
        catch (LoginFailedException ex) {
            this.getErrorHandler().error((AbstractBuilderError)new DeployError("error.deploy.login.failed", this.getReplaceMap()));
            this.deploy.getLogin().clearPassword();
        }
        catch (Exception ex) {
            this.getErrorHandler().error((AbstractBuilderError)new DeployError("error.deploy.unknown.error", this.getReplaceMap()));
            Logging.logger.severe("Caught a " + ex.getClass().getName() + ": " + ex.getMessage());
            Logging.logger.throwing(this.getClass().getName(), "checkAnswer", ex);
        }
    }

    private DeployError createError(BridgeResultError error) {
        DeployError deployError = new DeployError(error.getMessage());
        if (error.getMessage().contains("Permission denied")) {
            this.deploy.getLogin().setPassword(null);
        }
        return deployError;
    }

    @Override
    protected void propagateErrors() {
        super.propagateErrors();
        for (CompilableObject compilableObject : this.getCompilableObjects()) {
            compilableObject.getErrorHandler().serialize(true);
        }
    }
}

