/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks;

import ch.e2e.builder.base.error.AbstractErrorHandler;
import ch.e2e.builder.compiler.build.tasks.CompilerTask;
import ch.e2e.builder.compiler.build.tasks.Logging;
import ch.e2e.builder.compiler.build.tasks.control.CompileControl;
import ch.e2e.builder.compiler.build.types.Repository;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.descriptor.Library;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class CompileConfigurationTask
extends CompilerTask {
    CompilableObject compilableObject;
    String compilableObjectName;
    boolean isLibrary = false;

    protected CompileConfigurationTask(CompileControl ... compileControls) {
        super(compileControls);
    }

    public void setLibrary(boolean isLibrary) {
        this.isLibrary = isLibrary;
    }

    public void setCompilableObjectName(String compilableObjectName) {
        this.compilableObjectName = compilableObjectName;
    }

    public void setCompilableObject(CompilableObject compilableObject) {
        this.compilableObject = compilableObject;
        if (compilableObject != null) {
            this.compilableObjectName = compilableObject.getName();
            this.isLibrary = compilableObject instanceof Library;
        }
    }

    private CompilableObject getCompilableObject() {
        if (this.compilableObject != null) {
            return this.compilableObject;
        }
        if (this.compilableObjectName != null && this.getUmlDocument() != null && this.getUmlDocument().hasDescriptor()) {
            if (this.isLibrary) {
                return this.getUmlDocument().getDescriptor().getLibrary(this.compilableObjectName);
            }
            return this.getUmlDocument().getDescriptor().getCompilableObject(this.compilableObjectName);
        }
        return null;
    }

    public Set<CompilableObject> getCompilableObjects() {
        if (this.compilableObject != null || this.compilableObjectName != null) {
            HashSet<CompilableObject> result = new HashSet<CompilableObject>();
            CompilableObject compilableObject = this.getCompilableObject();
            if (compilableObject != null) {
                result.add(compilableObject);
            }
            return result;
        }
        return this.getUmlDocument().getDescriptor() != null ? this.getUmlDocument().getDescriptor().getCompilableObjects() : new HashSet();
    }

    protected Element getConfigurationElement(Deployment deployment, String configuration, File descriptorFolder) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        File descriptorFile = new File(descriptorFolder, deployment.getFilename());
        if (!descriptorFile.exists()) {
            descriptorFile = new File(descriptorFolder, deployment.getOldFilename());
        }
        Document descriptorDocument = DomUtilities.parse((File)descriptorFile, (boolean)false, (boolean)false);
        XPath xpath = DomUtilities.newXPath();
        Element result = (Element)xpath.evaluate(deployment.getNameXPath(configuration), descriptorDocument.getDocumentElement(), XPathConstants.NODE);
        if (result == null) {
            result = (Element)xpath.evaluate(deployment.getBackwardNameXPath(configuration), descriptorDocument.getDocumentElement(), XPathConstants.NODE);
        }
        return result;
    }

    protected Repository getRepository(CompilableObject compilableObject) {
        return new Repository(compilableObject);
    }

    protected void printDocument(Document doc, File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            DomUtilities.serialize((File)file, (Document)doc, (boolean)true, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (Exception ex) {
            Logging.logger.severe("Caught a " + ex.getClass().getName() + ": " + ex.getMessage());
            Logging.logger.throwing(this.getClass().getName(), ".printDocument", ex);
        }
    }

    @Override
    protected void propagateErrors() {
        super.propagateErrors();
        for (CompilableObject compilableObject : this.getCompilableObjects()) {
            this.getErrorHandler().addTo((AbstractErrorHandler)compilableObject.getErrorHandler());
            compilableObject.getErrorHandler().serialize(false);
        }
    }
}

