/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.action;

import ch.e2e.builder.compiler.build.action.CompilableObjectBuildAction;
import ch.e2e.builder.compiler.build.action.MissingDeploymentException;
import ch.e2e.builder.compiler.descriptor.CompilableObject;
import ch.e2e.builder.compiler.descriptor.Deployment;
import ch.e2e.builder.compiler.error.DeployErrorHandler;
import ch.e2e.builder.compiler.net.Login;
import java.util.Arrays;

public abstract class DeployBuildAction
extends CompilableObjectBuildAction {
    private Login login;
    private boolean startup;
    private boolean override;
    private DeployErrorHandler errorHandler;
    private String deployment;
    private boolean overrideSettings;

    public DeployBuildAction(CompilableObject configuration, Deployment deployment, Login login) {
        super(configuration, Arrays.asList(deployment));
        this.login = login;
        this.deployment = deployment.getName();
        this.errorHandler = deployment.getDeployErrorHandler();
        this.override = Boolean.getBoolean("ch.e2e.builder.compiler.webapp.overwrite");
        this.startup = Boolean.getBoolean("ch.e2e.builder.compiler.webapp.startup");
    }

    public DeployBuildAction(Login login, boolean startup, boolean override, boolean overrideSettings, DeployErrorHandler errorHandler) {
        this.login = login;
        this.startup = startup;
        this.override = override;
        this.overrideSettings = overrideSettings;
        this.errorHandler = errorHandler;
    }

    @Override
    public String getAction() {
        return "buildaction.deploy.configuration";
    }

    public Login getLogin() {
        return this.login;
    }

    public DeployErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean isOverride() {
        return this.override;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public boolean isOverrideSettings() {
        return this.overrideSettings;
    }

    @Override
    public void setCompilableObject(CompilableObject compilableObject) throws Exception {
        super.setCompilableObject(compilableObject);
        Deployment deployment = compilableObject.getDeployment(this.deployment);
        if (deployment == null) {
            throw new MissingDeploymentException(this.deployment);
        }
        this.errorHandler = deployment.getDeployErrorHandler();
    }

    public abstract String getRequestedPage();
}

