/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build;

import ch.e2e.builder.compiler.build.BuildException;
import ch.e2e.builder.compiler.build.tasks.MultipleOutputsCacheAbleTask;
import ch.e2e.builder.compiler.build.tasks.source.InputStreamSource;
import ch.e2e.builder.compiler.build.tasks.source.Source;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class UnzipTask
extends MultipleOutputsCacheAbleTask {
    public UnzipTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    protected abstract String getSourceId();

    @Override
    protected String getDestinationFileExtension() {
        return ".zip.file.list";
    }

    protected InputStream getUnzipInputStream() throws IOException {
        Source inputStreamSource = this.getSource(this.getSourceId());
        if (inputStreamSource instanceof InputStreamSource) {
            return ((InputStreamSource)inputStreamSource).getInputStream();
        }
        return null;
    }

    @Override
    protected Set<String> getDestinationFiles() {
        HashSet<String> filesFromZip = new HashSet<String>();
        this.unzipFile(zipPair -> filesFromZip.add(this.getEntryTargetPath((ZipEntry)zipPair.getType1())));
        return filesFromZip;
    }

    protected String getTargetFolder() {
        return this.getDestinationFilePathWithoutExtension();
    }

    @Override
    protected void executeTask(int dependencyLevel) throws BuildException {
        this.unzipFile(zipPair -> {
            ZipEntry zipEntry = (ZipEntry)zipPair.getType1();
            Path target = this.getSourceManager().getWorkFolder().toPath().resolve(this.getEntryTargetPath(zipEntry));
            if (!zipEntry.isDirectory()) {
                try {
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy((InputStream)zipPair.getType2(), target, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    protected void unzipFile(Consumer<Pair<ZipEntry, ZipInputStream>> unzipFunction) {
        try (ZipInputStream zipInputStream = new ZipInputStream(this.getUnzipInputStream());){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                unzipFunction.accept(new Pair<ZipEntry, ZipInputStream>(zipEntry, zipInputStream));
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String getEntryTargetPath(ZipEntry zipEntry) {
        return this.getTargetFolder() + "/" + this.getFilePath(zipEntry);
    }

    private String getFilePath(ZipEntry zipEntry) {
        return zipEntry.getName().replace(System.getProperty("file.separator"), "/");
    }

    private static class Pair<T1, T2> {
        private final T1 type1;
        private final T2 type2;

        public Pair(T1 type1, T2 type2) {
            this.type1 = type1;
            this.type2 = type2;
        }

        public T1 getType1() {
            return this.type1;
        }

        public T2 getType2() {
            return this.type2;
        }
    }
}

